//
//  YHBasicInfoFillViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHBasicInfoFillViewModel : YHBaseViewModel {
    //UI层需要的数据源
    var arrBasicInfoSessionDataForEdit : [YHBasicInfoSessionModel] = []
    
    //从网络请求的数据源
    var dataModelForBasicInfo : YHBasicInfoFillModel? {
        didSet {
            assembleBasicInfoData()
        }
    }
}

extension YHBasicInfoFillViewModel {
    
    private func createOrgBasiceInfoData() {
        var arrData : [YHBasicInfoSessionModel] = []
        do {
            //主申请人
            let model1 = YHBasicInfoCellModel(question: "1、是否曾在香港或其他地方因任何罪行或违法行为被定罪？", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾在香港或其他地方被拒入境／递解／遣送或要求离境？", answer: "", info: "")
            let model3 = YHBasicInfoCellModel(question: "3、是否曾被拒绝签发香港或其他地方的签证／进入许可？", answer: "", info: "")
            let model4 = YHBasicInfoCellModel(question: "4、是否曾触犯香港或任何地方的入境法例？", answer: "", info: "")
            let model5 = YHBasicInfoCellModel(question: "5、是否曾经使用另一个姓名或身份申请香港入境签证/进入许可或进入香港？", answer: "", info: "")
            let arr = [model1,model2,model3,model4,model5]
            
            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "主申请人", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }
        
        do {
            //配偶
            let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港?", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾被拒绝签发签证／进入许可以入境香港？", answer: "", info: "")
            let arr = [model1,model2]
            
            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "配偶", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }
        
        
        
        do {
            //子女 - xxx
            let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港?", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾被拒绝签发签证／进入许可以入境香港？", answer: "", info: "")
            let arr = [model1,model2]
            
            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "子女 - xxx", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }
        
        
        do {
            //家庭背景
            let model1 = YHBasicInfoCellModel(question:"1、至少一名直系家庭成员（已婚配偶、父母、兄弟姊妹、子女）是现居于香港的香港永久性居民", answer: "", info: "")
            let arr = [model1]
            
            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "家庭背景", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }
        
        arrBasicInfoSessionDataForEdit = arrData
    }
    //根据网络数据 组装数据
    private func assembleBasicInfoData() {
        guard let dataModelForBasicInfo = dataModelForBasicInfo else {
            createOrgBasiceInfoData()
            return
        }
        
        
        var arrData : [YHBasicInfoSessionModel] = []
        do {
            //主申请人
            if let model = dataModelForBasicInfo.applicant {
                let model1 = YHBasicInfoCellModel(question: "1、是否曾在香港或其他地方因任何罪行或违法行为被定罪？", answer: model.has_conviction?.has ?? "", info: model.has_conviction?.info ?? "")
                
                let model2 = YHBasicInfoCellModel(question: "2、是否曾在香港或其他地方被拒入境／递解／遣送或要求离境？", answer: model.has_departure?.has ?? "", info: model.has_departure?.info ?? "")
                
                let model3 = YHBasicInfoCellModel(question: "3、是否曾被拒绝签发香港或其他地方的签证／进入许可？", answer: model.has_deny?.has ?? "", info: model.has_deny?.info ?? "")
                
                let model4 = YHBasicInfoCellModel(question: "4、是否曾触犯香港或任何地方的入境法例？", answer: model.has_breaking_law?.has ?? "", info: model.has_breaking_law?.info ?? "")
                
                let model5 = YHBasicInfoCellModel(question: "5、是否曾经使用另一个姓名或身份申请香港入境签证/进入许可或进入香港？", answer: model.has_other_id?.has ?? "", info: model.has_other_id?.info ?? "")
                let arr = [model1,model2,model3,model4,model5]
                
                let sessionModel = YHBasicInfoSessionModel(sessionTitle: "主申请人", arrQuestionItem: arr)
                arrData.append(sessionModel)
            }
        }
        
        do {
            //配偶
            if let spouse = dataModelForBasicInfo.spouse {
                let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港?", answer: spouse.child_departure?.has ?? "", info: spouse.child_departure?.info ?? "")
                
                let model2 = YHBasicInfoCellModel(question: "2、是否曾被拒绝签发签证／进入许可以入境香港？", answer: spouse.child_deny?.has ?? "", info: spouse.child_deny?.info ?? "")
                let arr = [model1,model2]
                
                let sessionModel = YHBasicInfoSessionModel(sessionTitle: "配偶", arrQuestionItem: arr)
                arrData.append(sessionModel)
            }
        }
        
        do {
            //子女 - xxx
            if let arrChild = dataModelForBasicInfo.child {
                for item in arrChild {
                    let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港?", answer: item.child_departure?.has ?? "", info: item.child_departure?.info ?? "")
                    let model2 = YHBasicInfoCellModel(question: "2、是否曾被拒绝签发签证／进入许可以入境香港？", answer: item.child_deny?.has ?? "", info: item.child_deny?.info ?? "")
                    let arr = [model1,model2]
                    
                    
                    let title = "子女" + "-" + item.subset_name
                    let sessionModel = YHBasicInfoSessionModel(sessionTitle: title, arrQuestionItem: arr)
                    sessionModel.model = item
                    arrData.append(sessionModel)
                }
            }
        }
        
        
        
        
        do {
            //家庭背景
            if let model = dataModelForBasicInfo.background {
                let model1 = YHBasicInfoCellModel(question:"1、至少一名直系家庭成员（已婚配偶、父母、兄弟姊妹、子女）是现居于香港的香港永久性居民", answer: model.background_member?.has ?? "", info: model.background_member?.info ?? "",type: 1)
                model1.model = model
                let arr = [model1]
                let sessionModel = YHBasicInfoSessionModel(sessionTitle: "家庭背景", arrQuestionItem: arr)
                arrData.append(sessionModel)
            }
            
        }
        arrBasicInfoSessionDataForEdit = arrData
    }
}

extension YHBasicInfoFillViewModel {
    //获取基本资料信息
    func getBasicInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        //        createOrgBasiceInfoData()
        //        callBackBlock(true,nil)//先返回数据 让界面展示相关的UI
        
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Basics.basicInfoApi
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHBasicInfoFillModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                
                self.dataModelForBasicInfo = resultModel
                //根据返回值 组装 真实的数据
                callBackBlock(true,nil)
                
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg)
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    //保存基本资料信息
    func saveBasicInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Basics.updateBasicInfoApi
        let _ = YHNetRequest.postRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg)
                callBackBlock(false,error)
                
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}

