//
//  YHSingleLineInputCell.swift
//  galaxy
//
//  Created by edy on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemInputTextCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemInputTextCell"
    let horizonalGap = 18.0
    // 是否必填 如必填title会展示红色*
    var isMust = false
    // 是否隐藏顶部分割线
    var isHiddenTopLine:Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    // BOOL值表示编辑是否结束
    var textChange:((String?, Bool)->Void)?
    var textInputCondtion:((UITextField)->Bool)?
    var title:String? {
        didSet {
            
            if let title = title, !title.isEmpty {
                let str = (isMust ? ("*"+title) : title)
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: UIColor.mainTextColor
                ]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                if isMust {
                    let starRange = NSRange(location: 0, length: 1)
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                titleLabel.attributedText = questionAttrStr
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var placeHolder:String? {
        didSet {
            if let placeHolder = placeHolder, !placeHolder.isEmpty {
                textField.attributedPlaceholder = NSAttributedString(string: placeHolder, attributes: [NSAttributedString.Key.foregroundColor : UIColor.placeHolderColor])
            } else {
                textField.attributedPlaceholder = NSAttributedString(string: "请输入", attributes: [NSAttributedString.Key.foregroundColor : UIColor.placeHolderColor])
            }
        }
    }
    
    var text:String? {
        didSet {
            textField.text = text
        }
    }

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    lazy var textField:UITextField = {
        let textField = UITextField()
        textField.backgroundColor = .clear
        textField.placeholder = "请输入"
        textField.font = UIFont.PFSC_M(ofSize: 14)
        textField.tintColor = UIColor.brandMainColor
        textField.textColor = UIColor.mainTextColor
        textField.addTarget(self, action: #selector(textFieldChanged(textField:)), for: .editingChanged)
        textField.addTarget(self, action: #selector(textFieldEditEnd(textField:)), for: .editingDidEnd)
        return textField
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.isHidden = true
        return label
    }()
    
    private lazy var topLine:UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(textField)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(topLine)

        isMust = true
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.width.equalTo(120)
            make.top.equalToSuperview().offset(16)
        }
        
        textField.snp.makeConstraints { make in
            make.top.equalTo(titleLabel)
            make.right.equalTo(contentView.snp.right).offset(-horizonalGap)
            make.left.equalTo(titleLabel.snp.right).offset(10)
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
        
        setTips("", isShow: false)
    }
    
    func setTips(_ tips:String?, isShow:Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(textField.snp.bottom).offset(6)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(textField.snp.bottom)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    
    @objc func textFieldChanged(textField:UITextField) {
        if let textChange = textChange {
            if let textInputCondtion = textInputCondtion {
                if textInputCondtion(self.textField) {
                    textChange(textField.text, false)
                }
            } else {
                textChange(textField.text, false)
            }
        }
    }
     
    @objc func textFieldEditEnd(textField:UITextField) {
        if let textChange = textChange {
            if let textInputCondtion = textInputCondtion {
                if textInputCondtion(self.textField) {
                    textChange(textField.text, true)
                }
            } else {
                textChange(textField.text, true)
            }
        }
    }
}
