//
//  YHMainInformationCountryTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMainInformationTableViewCell: UITableViewCell {
    typealias InformationBlock = (_ model: YHItemModel) -> ()
    var informationBlock: InformationBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var country: String = ""
    var dataSource: YHSectionItemModel?{
        didSet {
            updateAllViews()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(52)
        }
    }
    
    func updateAllViews() {
        titleLabel.text = dataSource?.title
        mainItemView.removeSubviews()
        var y = 0
        for i in 0 ..< (dataSource?.models?.count ?? 0) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            y = y + 1
            var h = 51
            let data = dataSource?.models?[i] ?? YHItemModel()
            let isShow = data.isShowPrompts ?? false
            let message = data.message ?? ""
            let isNeed = data.isNeed ?? false
            if data.id == .id3 || data.id == .id4 || data.id == .id32 || data.id == .id33 {
                if isShow && message.count == 0 && isNeed {
                    h = 71 + 20
                } else {
                    h = 71
                }
            } else {
                if isShow && message.count == 0 && isNeed {
                    h = 51 + 20
                } else {
                    h = 51
                }
            }
            
            let itemView = YHItemView()
            itemView.dataSource = data
            itemView.country = country
            itemView.block = {[weak self] model in
                guard let self = self else { return }
                if let block = self.informationBlock {
                    block(model)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y = y + h
        }
    }
}
