//
//  YHMainInfoPreviewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHMainInfoPreviewModel: SmartCodable {
    var username: String  = ""
    var used_name: String  = ""
    var username_pinyin : String = ""
    var sex : String = ""
    var birthday: String  = ""
    var birth_place: String  = ""
    var mobile: String  = ""
    var email: String  = ""
    var married: String  = ""
    var nationality: String  = ""
    var live_address: String = ""
    var surname: String  = ""
    var birth_place_details : String  = ""
    var live_address_detail : String  = ""
    var is_handled: Int  = 0
    var is_live_oversea_year: Int  = 0
    
    var hk_id : YHChildStepchildClass?
    var certificates:YHCertificatesPreviewModel?
    
    required init() {
        
    }
}


class YHCertificatesPreviewModel: SmartCodable {
    
    var cnIdentityCard: YHCNIdentityCardPreviewModel = YHCNIdentityCardPreviewModel()
    var passport: YHCNIdentityCardPreviewModel = YHCNIdentityCardPreviewModel()
    var hkMacaoPass: YHCNIdentityCardPreviewModel = YHCNIdentityCardPreviewModel()

    enum CodingKeys: String, CodingKey {
        case cnIdentityCard = "cn_identity_card"
        case passport = "passport"
        case hkMacaoPass = "hk_macao_pass"
    }
        
    required init() {
        
    }
}


class YHCNIdentityCardPreviewModel: SmartCodable {
    
    static let longTime = "8888-01-01"
    var id: Int = 0
    var number: String = ""
    var issueAt: String = ""
    var issueDateStartAt: String = ""
    var issueDateEndAt: String = ""
    var imgFront: String = ""
    var imgBack: String = ""
    var passport_type: Int = -1
    var type: String = ""

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case number = "number"
        case issueAt = "issue_at"
        case issueDateStartAt = "issue_date_start_at"
        case issueDateEndAt = "issue_date_end_at"
        case imgFront = "img_front"
        case imgBack = "img_back"
        case passport_type = "pass_port_type"
        case type = "type"
    }
    
    required init() {
        
    }
}
