//
//  YHServiceNoOrderView.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceNoOrderView: UIView {
    public var clickBackBtnClickBlock : (()->())?
    public var clickShowBtnClickBlock : (()->())?

    private lazy var iconImgV : UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "no_data_bg_order")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    private lazy var tipsLab : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 14)
        lable.textAlignment = .center
        lable.text = "您还没有相关订单"
        return lable
    }()
    
    private lazy var noFindLab : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.yhGreyColor
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textAlignment = .center
        lable.text = "找不到订单"
        return lable
    }()
    
    private lazy var showBtn : UIButton = {
        let btn = UIButton(type: .custom)
        btn.setBackgroundImage(UIImage(named: "service_no_order_alert"), for: .normal)
        return btn
    }()
    
    private lazy var backBtn : UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("参与测评", for: .normal)
        btn.layer.cornerRadius = kCornerRadius3
        btn.clipsToBounds = true
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        btn.setTitleColor(.white, for: .normal)
        return btn
    }()
    
    public override init(frame: CGRect) {
        super.init(frame:frame)
        initView()
    }
    
    private func initView() {
        addSubview(iconImgV)
        iconImgV.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.centerX.equalToSuperview()
            make.height.equalTo(128)
            make.width.equalTo(128)
        }
        
        addSubview(tipsLab)
        tipsLab.snp.makeConstraints { make in
            make.top.equalTo(iconImgV.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.left.right.equalToSuperview()
        }
        
        addSubview(noFindLab)
        noFindLab.snp.makeConstraints { make in
            make.top.equalTo(tipsLab.snp.bottom).offset(8.5)
            make.centerX.equalToSuperview().offset(-8)
        }
        
        addSubview(showBtn)
        showBtn.snp.makeConstraints { make in
            make.left.equalTo(noFindLab.snp.right).offset(2)
            make.centerY.equalTo(noFindLab.snp.centerY)
            make.width.height.equalTo(16)
        }
        
        addSubview(backBtn)
        backBtn.snp.makeConstraints { make in
            make.top.equalTo(noFindLab.snp.bottom).offset(22.5)
            make.centerX.equalToSuperview()
            make.height.equalTo(38)
            make.width.equalTo(84)
        }
        showBtn.addTarget(self, action: #selector(showBtnClick), for: .touchUpInside)
        backBtn.addTarget(self, action: #selector(backBtnClick), for: .touchUpInside)
        showBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
        layoutIfNeeded()
        backBtn.backgroundColor = .brandMainColor
        backBtn.addYinHeGradualLayer()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func backBtnClick() {
        self.clickBackBtnClickBlock?()
    }
    
    @objc func showBtnClick() {
        self.clickShowBtnClickBlock?()
    }
}
