//
//  YHServiceOrderSearchViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceOrderSearchViewModel: YHBaseViewModel {
    var arrContactList : [YHContactItemModel] = []

    //请求白名单
    func getWhitelist(callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.bywhitelist
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                let dic = json.data as! Dictionary<String, Any>
                let data = dic["Data"]
                guard let result = [YHServiceSearchModel].deserialize(from: data as? [Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                if result.count != 0, let model = result.first, model?.dictionary_code.count != 0 {
                    callBackBlock(true, nil)
                } else {
                    callBackBlock(false,nil)
                }
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //请求合同项
    func getSearchList(_ order: String, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let params:[String:Any] = ["order_sn": order]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.byorderid
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = [YHContactItemModel].deserialize(array: dic as? [Any]) else {
                    self.arrContactList = []
                    callBackBlock(false,nil)
                    return
                }
                let lastArray = resultModel.compactMap { $0 }
                self.arrContactList = lastArray
                callBackBlock(true,nil)
            } else {
                self.arrContactList = []
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false,error)
            }
        } failBlock: { err in
            self.arrContactList = []
            callBackBlock(false,err)
        }
    }
    
    func getAssistList(callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.assist
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data as! [String: Any]
                let data = dic["orders"] as? [Any]
                guard let resultModel = [YHContactItemModel].deserialize(array: data) else {
                    self.arrContactList = []
                    callBackBlock(false,nil)
                    return
                }
                let lastArray = resultModel.compactMap { $0 }
                self.arrContactList = lastArray
                callBackBlock(true,nil)
            } else {
                self.arrContactList = []
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false,error)
            }
        } failBlock: { err in
            self.arrContactList = []
            callBackBlock(false,err)
        }
    }
    
    
    
}
