//
//  YHListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/7/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHListViewModel: YHBaseViewModel {
    var model: [YHHKEventModel] = []
    
    func getToolsEvent(pid: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.hklistApi
        
        let param = ["pid[0]": pid]
        let _ = YHNetRequest.getRequest(url: strUrl, params:param) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = [YHHKEventModel].deserialize(from: dic as? [Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                self.model = (result as! [YHHKEventModel])
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false,err)
        }
    }

}
