//
//  YHAboutGalaxyViewController.swift
//  galaxy
//
//  Created by edy on 2024/7/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAboutGalaxyViewController: YHBaseViewController {

    lazy var navBar: YHCustomNavigationBar = {
        let bar = YHCustomNavigationBar.navBar()
        bar.backgroundColor = .clear
        bar.titleColor = .white
        bar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
        bar.backBlock = {
            [weak self] in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
        return bar
    }()
    
    lazy var statusBar: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: CGRect.zero, style:.grouped)
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.estimatedSectionHeaderHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.tableHeaderView = headerView
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.bounces = false
        tableView.register(YHAboutUsCell.self, forCellReuseIdentifier: YHAboutUsCell.cellReuseIdentifier)
        tableView.delegate = self
        tableView.dataSource = self
        return tableView
    }()
    
    lazy var bgImageView:UIImageView = {
        let view = UIImageView(image: UIImage(named: "about_bg"))
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    lazy var aboutLabel = {
        var label = UILabel()
        label.text = "关于我们".local
        label.textColor = UIColor.white
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_M(ofSize: 30)
        return label
    }()
    
    lazy var detailLabel = {
        var label = UILabel()
//        label.text = "专注海外服务17年，总部设立在深圳，现已分别在北京、上海、广州等地建立分公司，立足于香港身份规划服务，业务逐步多元化发展。"
        label.textColor = UIColor.white
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.numberOfLines = 0
        label.lineBreakMode = .byTruncatingTail
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 5.0 // 设置行间距
        let attributedString = NSMutableAttributedString(string: "专注海外服务17年，总部设立在深圳，现已分别在北京、上海、广州等地建立分公司，立足于香港身份规划服务，业务逐步多元化发展。".local)
        attributedString.addAttribute(.paragraphStyle, value: paragraphStyle, range: NSRange(location: 0, length: attributedString.length))
        label.attributedText = attributedString
        return label
    }()
    
    lazy var headerView:UIView = {
       let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 496))
       view.clipsToBounds = true
       view.addSubview(bgImageView)
       view.addSubview(aboutLabel)
       view.addSubview(detailLabel)
        bgImageView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(496.0)
        }
        aboutLabel.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar+12.5)
            make.left.equalTo(20.0)
            make.right.equalTo(-20.0)
            make.height.equalTo(42.0)
        }
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(aboutLabel.snp.bottom).offset(12)
            make.left.equalTo(20.0)
            make.right.equalTo(-20.0)
        }
       return view
    }()
    
    lazy var items:[AboutAdvantageItem] = {
        return [AboutAdvantageItem(iconName: "about_match", title: "精准匹配".local, detail: "大数据精准匹配，专属方案获批率更高", url: ""),
                AboutAdvantageItem(iconName: "about_response", title: "快速响应", detail: "身份规划师一对一专业服务，第一时间响应您的需求", url: ""),
                AboutAdvantageItem(iconName: "about_service", title: "专业服务", detail: "文案导师团队倾力支持", url: ""),
                AboutAdvantageItem(iconName: "about_guarantee", title: "获批保障", detail: "全球每3位香港优才获批者就有1位来自银河", url: "")]
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createUI()
    }
    
    func createUI() {
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        self.view.addSubview(self.tableView)
        self.view.addSubview(statusBar)
        self.view.addSubview(navBar)
        self.navBar.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_statusBar())
            make.height.equalTo(k_Height_NavContentBar)
        }
        self.statusBar.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview()
            make.height.equalTo(k_Height_statusBar())
        }
        self.tableView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}

extension YHAboutGalaxyViewController : UITableViewDelegate, UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: YHAboutUsCell.cellReuseIdentifier, for: indexPath) as! YHAboutUsCell
        let item = items[indexPath.row];
        cell.item = item
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 93.0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        let label = UILabel()
        label.text = "四大优势".local
        label.textColor = UIColor.mainTextColor
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_M(ofSize: 21)
        view.addSubview(label)
        label.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(20)
            make.height.equalTo(30)
        }
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 33.0+18.0+46.0
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let view = UIView()
        let label = UILabel()
        label.text = "美好新生活从这里开始".local
        label.textColor = UIColor.brandMainColor(alpha: 0.24)
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        view.addSubview(label)
        let line1 = UIView()
        line1.backgroundColor = UIColor.brandMainColor(alpha: 0.16)
        view.addSubview(line1)
        let line2 = UIView()
        line2.backgroundColor = UIColor.brandMainColor(alpha: 0.16)
        view.addSubview(line2)
        label.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(33.0)
            make.height.equalTo(18)
        }
        line1.snp.makeConstraints { make in
            make.width.equalTo(16.0)
            make.height.equalTo(1)
            make.centerY.equalTo(label)
            make.right.equalTo(label.snp.left).offset(-12)
        }
        line2.snp.makeConstraints { make in
            make.width.equalTo(16.0)
            make.height.equalTo(1)
            make.centerY.equalTo(label)
            make.left.equalTo(label.snp.right).offset(12)
        }
        return view
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        printLog("\(scrollView.contentOffset.y)")
        var alpha = scrollView.contentOffset.y/k_Height_NavigationtBarAndStatuBar
        if alpha > 1.0 {
            alpha = 1.0
        } else if alpha < 0.0 {
            alpha = 0.0
        }
        
        self.navBar.backgroundColor = UIColor.init(hex: 0xFFFFFF, alpha: alpha)
        self.statusBar.backgroundColor = UIColor.init(hex: 0xFFFFFF, alpha: alpha)
        
        if scrollView.contentOffset.y > 0 {
            self.navBar.backButton.setImage(UIImage(named: "back_icon"), for: .normal)

        } else {
            self.navBar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
        }
    }
}
