//
//  YHAboutUsCell.swift
//  galaxy
//
//  Created by edy on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAboutUsCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHAboutUsCell"
    
    var item: AboutAdvantageItem? {
        didSet {
            if let item = item {
                iconImgView.image = UIImage(named: item.iconName)
                titleLabel.text = item.title
                detailLabel.text = item.detail
            }
        }
    }

    lazy var iconImgView:UIImageView = {
        let icon = UIImageView(image: UIImage(named: "mine_manager"))
        return icon
    }()
    
    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 15)
        return label
    }()
    
    lazy var detailLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.numberOfLines = 0
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = UIColor.clear
        contentView.addSubview(iconImgView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        
        iconImgView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(20)
            make.width.height.equalTo(58.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView).offset(8.0)
            make.height.equalTo(21)
            make.left.equalTo(iconImgView.snp.right).offset(20)
            make.right.equalTo(-20)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(20)
            make.right.equalTo(-20)
            make.top.equalTo(titleLabel.snp.bottom).offset(5.0)
            make.bottom.equalToSuperview().offset(-27)
        }
    }
}
