//
//  YHEducationCertificateConfirmCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHEducationCertificateConfirmCell: UITableViewCell {

    static let cellReuseIdentifier = "YHEducationCertificateConfirmCell"
    
    private let btnWidth = 70.0
    private let btnHeight = 32.0
    private let titleFont = UIFont.PFSC_R(ofSize: 14)
    private let btnTitleSelectColor = UIColor.brandMainColor
    private let btnTitleDefaultColor = UIColor.mainTextColor
    private let btnBgDefaultColor = UIColor.contentBkgColor
    private let btnBgSelectColor = UIColor.brandMainColor.withAlphaComponent(0.08)
    private let answerBaseTag  = 9527
    
    // 是否必须字段
    var isCheck: Bool = false
    var answerBlock: (([YHFormChoiceItem], Int) -> Void)?
    
    // 必须传2个item的arr
    var answerArr: [YHFormChoiceItem]? {
        didSet {
            if let answerArr = answerArr, answerArr.count == 2 {
                
                var isSelectTrue: Bool?
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    let item = answerArr[i]
                    answerBtn.setTitle(item.title, for: .normal)
                    updateAnswerButton(answerBtn, item.isSelect)
                    if item.isSelect {
                        isSelectTrue = (i == 0)
                    }
                }
                if let isSelectTrue = isSelectTrue { // 进行过选择
                    if isSelectTrue == false {
                        let a: ASAttributedString = .init("若不能提供以上证明材料，将导致您的该学历", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
                        let b: ASAttributedString = .init("不被认可不予加分", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
                        let c: ASAttributedString = .init("，请尽可能准备以上材料并修改此选项。", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
                        tipsLabel.attributed.text = a+b+c
                        isNeedShowTips(true)
                        
                    } else {
                        tipsLabel.attributed.text = ""
                        isNeedShowTips(false)
                    }
                    
                } else { // 没有选择
                    if isCheck {
                        let tips: ASAttributedString = .init("请选择", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
                        tipsLabel.attributed.text = tips
                        isNeedShowTips(true)
                        
                    } else {
                        tipsLabel.attributed.text = ""
                        isNeedShowTips(false)
                    }
                }
                
            } else {
                // 重置所有答案状态
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    answerBtn.setTitle("", for: .normal)
                    updateAnswerButton(answerBtn, false)
                }
            }
        }
    }
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.lineBreakMode = .byCharWrapping
        label.text = "证件提供确认"
        return label
    }()
    
    private lazy var questionContentView: UIView = {
        let view = UIView()
        return view
    }()
    
    private lazy var questionLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .left
        label.numberOfLines = 0
        let a: ASAttributedString = .init("*", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
        let b: ASAttributedString = .init("您是否可以提供以下所有证明文件", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        label.attributed.text = a+b
        return label
    }()
    
    private lazy var answer1Btn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var answer2Btn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag+1
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var markContentView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xF8F9FB)
        return view
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("若不能提供以上证明材料，将导致您的该收入", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
        let b: ASAttributedString = .init("不被认可不予加分", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
        let c: ASAttributedString = .init("，请尽可能准备以上材料并修改此选项。", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
        label.attributed.text = a+b+c
        return label
    }()
    
    var tipsArr: [String] = ["国内院校需提供：学位证+毕业证+学位认证报告",
                            "国外院校需提供：学位证+成绩单+留服认证报告"]
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        contentView.addSubview(titleLabel)
        contentView.addSubview(topLine)
        contentView.addSubview(questionContentView)
        questionContentView.addSubview(questionLabel)
        questionContentView.addSubview(answer1Btn)
        questionContentView.addSubview(answer2Btn)
        contentView.addSubview(markContentView)
        contentView.addSubview(tipsLabel)

        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        topLine.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }

        questionContentView.snp.makeConstraints { make in
            make.top.equalTo(topLine.snp.bottom).offset(0)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        questionLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(answer1Btn.snp.left).offset(-15)
            make.top.equalTo(16)
            make.bottom.equalTo(-16)
        }
        
        answer1Btn.snp.makeConstraints { make in
            make.centerY.equalTo(questionLabel)
            make.width.equalTo(74)
            make.height.equalTo(32)
            make.right.equalTo(answer2Btn.snp.left).offset(-12)
        }
        
        answer2Btn.snp.makeConstraints { make in
            make.centerY.equalTo(questionLabel)
            make.width.equalTo(74)
            make.height.equalTo(32)
            make.right.equalTo(0)
        }
        
        markContentView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(questionContentView.snp.bottom).offset(0)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(markContentView.snp.bottom).offset(16)
            make.bottom.equalTo(-16)
        }
        
        var lastTipsView: YHEducationMarkView?
        for (index, tips) in tipsArr.enumerated() {
            let tipsView = YHEducationMarkView(frame: .zero)
            tipsView.title = tips
            markContentView.addSubview(tipsView)
            tipsView.snp.makeConstraints { make in
                make.left.equalTo(16)
                make.right.equalTo(-16)
                if let lastTipsView = lastTipsView {
                    make.top.equalTo(lastTipsView.snp.bottom).offset(12)
                } else {
                    make.top.equalTo(16)
                }
                
                if index == tipsArr.count-1 {
                    make.bottom.equalTo(-16)
                }
            }
            lastTipsView = tipsView
        }
    }
    
    // 更新答案按钮选中状态
    private func updateAnswerButton(_ btn: UIButton, _ isSelect: Bool) {
        btn.layer.borderColor = (isSelect ? btnTitleSelectColor : .clear).cgColor
        btn.setTitleColor((isSelect ? btnTitleSelectColor : btnTitleDefaultColor), for: .normal)
        btn.backgroundColor = (isSelect ? btnBgSelectColor : btnBgDefaultColor)
    }
    
    @objc func didClickResponseBtn(btn: UIButton) {
        
        let selectIndex = btn.tag-answerBaseTag
        if let resultArr = answerArr, resultArr.count == 2 {
            
            for i in 0...1 {
                let item = resultArr[i]
                item.isSelect = (i == selectIndex)
            }
            answerArr = resultArr
            if let answerBlock = answerBlock {
                answerBlock(resultArr, selectIndex)
            }
        }
    }
    
    func isNeedShowTips(_ isShow: Bool) {
        
        tipsLabel.isHidden = !isShow
        tipsLabel.snp.remakeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(markContentView.snp.bottom).offset(16)
            make.bottom.equalTo(isShow ? -16 : 0)
            if !isShow {
                make.height.equalTo(0)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }

}
