//
//  YHScanModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

// MARK: - 扫码场景类型(支持复合类型)

struct YHScanType: OptionSet {
    let rawValue: Int

    static let checkIn = YHScanType(rawValue: 1 << 0) // 签到
    static let smartCabinet = YHScanType(rawValue: 1 << 1) // 智能柜

    // 预留扩展位
    // static let document      = YHScanType(rawValue: 1 << 2)  // 文档
    // static let payment       = YHScanType(rawValue: 1 << 3)  // 支付

    /// 所有类型
    static let all: YHScanType = [.checkIn, .smartCabinet]

    var title: String {
        if self == .checkIn {
            return "扫码签到"
        } else if self == .smartCabinet {
            return "智能柜扫码"
        } else if self == .all {
            return "扫码"
        } else {
            return "多功能扫码"
        }
    }
    
    var prefixString: String {
        if self == .checkIn {
            return "SLQD_"
        } else {
            return ""
        }
    }

    var instructionText: String? {
        if self == .checkIn {
            return "将二维码放到框内"
        } else if self == .smartCabinet {
            return "将二维码放到框内"
        } else if contains(.checkIn) && contains(.smartCabinet) {
            return "将二维码放到框内"
        } else {
            return "将二维码放到框内"
        }
    }

    /// 从二维码内容识别类型
    func recognizeType(from code: String) -> YHScanType? {
        // 根据二维码内容规则识别类型
        if contains(.checkIn) && code.hasPrefix(YHScanType.checkIn.prefixString) {
            return .checkIn
        }

//        if contains(.smartCabinet) && code.hasPrefix("CABINET_") {
//            return .smartCabinet
//        }


        // 如果只有一个类型,直接返回
        if self == .checkIn {
            return .checkIn
        } else if self == .smartCabinet {
            return .smartCabinet
        }

        return nil
    }
}

// MARK: - 扫码结果回调

typealias YHScanCompletion = (YHScanResult) -> Void

struct YHScanResult {
    let code: String
    let recognizedType: YHScanType? // 识别出的具体类型
    let supportedTypes: YHScanType // 支持的类型集合
    let timestamp: Date

    init(code: String, recognizedType: YHScanType?, supportedTypes: YHScanType) {
        self.code = code
        self.recognizedType = recognizedType
        self.supportedTypes = supportedTypes
        timestamp = Date()
    }
}
