//
//  YHMySectionGroupCell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/13.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySectionGroupCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMySectionGroupCell"
    
    var clickItem: ((PersonalModuleItem) -> Void)?
    
    func updateGroup(_ group: YHFunctionGroupInfo) {
        titleLabel.text = group.title
        groupArr = group.arr
    }

    var groupArr: [PersonalModuleItem] = [] {
        didSet {
            let countPerRow = 4
            let rowHeight = 70.0
            var listHeight = rowHeight
            if groupArr.count%countPerRow == 0 {
                listHeight = rowHeight * Double(groupArr.count/countPerRow)
            } else {
                listHeight = rowHeight * Double(groupArr.count/countPerRow + 1)
            }
            collectionView.snp.updateConstraints { make in
                make.height.equalTo(listHeight)
            }
            collectionView.reloadData()
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var whiteView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 4.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()
    
    lazy var collectionView: UICollectionView = {
        
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.minimumInteritemSpacing = 0.0
        flowLayout.minimumLineSpacing = 0.0
        flowLayout.scrollDirection = .vertical
        
        let collectView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectView.backgroundColor = .clear
        collectView.delegate = self
        collectView.dataSource = self
        collectView.register(YHMyFunctionGroupItemCell.self, forCellWithReuseIdentifier: YHMyFunctionGroupItemCell.cellReuseIdentifier)
        collectView.contentInset = .zero
        collectView.showsVerticalScrollIndicator = false
        collectView.contentInsetAdjustmentBehavior = .never
        return collectView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteView)
        whiteView.addSubview(titleLabel)
        whiteView.addSubview(collectionView)
        
        whiteView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.bottom.equalTo(-16)
        }
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(16)
            make.height.equalTo(20)
        }
        collectionView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(20)
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(90)
        }
    }

}

extension YHMySectionGroupCell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    // 返回单元格数量
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        return groupArr.count
    }
    
    // 返回每个单元格的大小
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        let width = floor((KScreenWidth-20.0*2.0)/4.0)
        return CGSize(width: width, height: 70.0)
    }
    
    // 返回自定义单元格
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHMyFunctionGroupItemCell.cellReuseIdentifier, for: indexPath) as? YHMyFunctionGroupItemCell else { return UICollectionViewCell() }
        if 0 <= indexPath.item && indexPath.item < groupArr.count {
            let item: PersonalModuleItem = groupArr[indexPath.item]
            cell.updateItem(item)
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if 0 <= indexPath.item && indexPath.item < groupArr.count {
            let item: PersonalModuleItem = groupArr[indexPath.item]
            if let click = clickItem {
                click(item)
            }
        }
    }
}
