//
//  AppDelegate.swift
//  galaxy
//
//  Created by davidhuangA on 2023/12/19.
//

import UIKit
import ESTabBarController_swift
import IQKeyboardManagerSwift
import SmartCodable
import GKNavigationBarSwift
import DeviceKit

@main
class AppDelegate: UIResponder, UIApplicationDelegate, WXApiDelegate {
    var window: UIWindow?
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        
        // JPush服务注册
        registerJPushService(launchOptions)
        
        //全局导航栏、返回事件/手势
        setupNavBar()
        
        //2.通用UI设置
        setupWholeUI()
        
        //3.其他第三方sdk设置
        thirdSetting()
        
        //4.本地用户信息加载
        YHLoginManager.shared.loadLocalUserInfoData()
        YHConfigManager.shared.loadConfigData()
        //微信注册app
        WXApi.registerApp("wx06b21f3c7a5ba594", universalLink: "https://www.galaxy-immi.com/app1/")
        WXApi.startLog(by: .detail) { string in
            print("\(string)")
        }
        //1.设置主窗口
        setupRootVC()
        return true
    }
    
    func application(_ app: UIApplication, open url: URL, options: [UIApplication.OpenURLOptionsKey : Any] = [:]) -> Bool {
        if YHAnalytics.handleSchemeUrl(url) ?? false {
            return true
        }
        return true
    }
    
    
    func setupNavBar() {
        GKConfigure.setupDefault()
    }
    
    func application(_ application: UIApplication, handleOpen url: URL) -> Bool {
        return WXApi.handleOpen(url, delegate: self)
    }
    
    func application(_ application: UIApplication, open url: URL, sourceApplication: String?, annotation: Any) -> Bool {
        return WXApi.handleOpen(url, delegate: self)
    }
    
    func application(_ application: UIApplication, continue userActivity: NSUserActivity, restorationHandler: @escaping ([UIUserActivityRestoring]?) -> Void) -> Bool {
        return WXApi.handleOpenUniversalLink(userActivity, delegate: self)
    }
    
    func application(_ application: UIApplication, continue userActivity: NSUserActivity, restorationHandler: @escaping ([Any]?) -> Void) -> Bool {
        return WXApi.handleOpenUniversalLink(userActivity, delegate: self)
    }
}


extension AppDelegate {
    private func thirdSetting() -> Void {
        //1.数据解析
#if DEBUG
        SmartConfig.debugMode = .none
#elseif TESTNEV
        SmartConfig.debugMode = .none
#else
        SmartConfig.debugMode = .none
#endif
        
        //2.bugly参数设置
#if DEBUG
        Bugly.start(withAppId: "3b10faa43e")
#elseif TESTNEV
        Bugly.start(withAppId: "3b10faa43e")
#else
        Bugly.start(withAppId: "5dc2acc53e")
#endif
    }
    
    //2.通用全局UI设置相关
    private func setupWholeUI() -> Void {
        
        DispatchQueue.global().async {
            //异步延迟设置
            DispatchQueue.main.asyncAfter(wallDeadline: .now() + 0.25) { [] in
                //1、系统控件属性设置
                UITextField.appearance().tintColor = .brandMainColor
                UITextView.appearance().tintColor = .brandMainColor
                
                IQKeyboardManager.shared.enable = true
                IQKeyboardManager.shared.enableAutoToolbar = false
                IQKeyboardManager.shared.resignOnTouchOutside = true  //控制点击背景是否收起键盘
            }
        }
        
        YHNetworkStatusManager.shared.listenNetWorkStatus()
    }
    
    //1.设置主窗口
    private func setupRootVC() {
        let nav = YHNavigationController(rootVC:YHStartPageViewController())
        window = UIWindow(frame: UIScreen.main.bounds)
        window?.rootViewController = nav
        window?.makeKeyAndVisible()
    }
}


