//
//  YHNoDataTipView.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/25.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit
class YHNoDataTipView: UIView {
    
    public var reloadBlock: (()->())?
    
    private var imageStr: String = "no-order-bkg-icon"
    private var title: String = "暂无数据"
    
    private lazy var imageView: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "no-order-bkg-icon"))
        return imageView
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel(text: "暂无数据", font: UIFont.PFSC_R(ofSize: 14), color: UIColor.labelTextColor2)
        return label
    }()
    
    private lazy var descLabel: UILabel = {
        let label = UILabel(text: "", font: UIFont.PFSC_R(ofSize: 12), color: UIColor.labelTextColor2)
        return label
    }()
    
    private lazy var reloadBtn: UIButton = {
        let btn = UIButton.bs_button(title: "重新加载", font: UIFont.PFSC_M(ofSize: 12), normalColor: UIColor.brandMainColor)
        btn.layer.cornerRadius = kCornerRadius3
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.labelTextColor2.cgColor
        btn.addTarget(self, action: #selector(onReloadData), for: .touchUpInside)
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    public func setup(image: String? = nil, title: String) {
        if let image = image {
            imageView.image = UIImage(named: image)
            self.imageStr = image
        }
        titleLabel.text = title
        self.title = title
    }
    
    
    override var isHidden: Bool {
        didSet {
            if isHidden == false {
                if  YHNetworkStatusManager.shared.isNetWorkOK == true {
                    imageView.image = UIImage(named: self.imageStr)
                    titleLabel.text = title
                    descLabel.isHidden = true
                    reloadBtn.isHidden = true
                } else {
                    imageView.image = UIImage(named: "no_data_network_icon")
                    titleLabel.text = "网络好像断开了哦"
                    descLabel.isHidden = false
                    reloadBtn.isHidden = false
                }
            }
        }
    }
    
}


// MARK: - 提供快速创建的类方法
extension YHNoDataTipView {
    
    private func initView() {
        self.addSubview(imageView)
        self.addSubview(titleLabel)
        self.addSubview(descLabel)
        self.addSubview(reloadBtn)
        
        let imageViewTop = 132 / (UIDevice.kScreenW - UIDevice.bs_navigationFullHeight())
        imageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(imageViewTop)
            make.centerX.equalToSuperview()
            make.width.height.equalTo(165)
        }
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(imageView.snp.bottom)
            make.centerX.equalToSuperview()
        }
        descLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.centerX.equalToSuperview()
        }
        reloadBtn.snp.makeConstraints { make in
            make.top.equalTo(descLabel.snp.bottom).offset(16)
            make.centerX.equalToSuperview()
            make.width.equalTo(80)
            make.height.equalTo(28)
        }
        
        descLabel.isHidden = true
        reloadBtn.isHidden = true
    }
    
    //    class func noDataTipView() -> YHNoDataTipView {
    //        return YHNoDataTipView()
    //        //return Bundle.main.loadNibNamed("YHNoDataTipView", owner: nil, options: nil)?.first as! YHNoDataTipView
    //    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        let imageViewTop = (132 + UIDevice.bs_navigationFullHeight()) / UIDevice.kScreenH * self.frame.size.height
        imageView.snp.updateConstraints { make in
            make.top.equalToSuperview().offset(imageViewTop)
        }
    }
    
    @objc private func onReloadData() {
        reloadBlock?()
    }
    
}
