//
//  YHFourKingViewController.swift
//  galaxy
//
//  Created by EDY on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFourKingViewController: YHBaseViewController {
    let homeViewModel: YHHomePageViewModel = YHHomePageViewModel()
    var tableFootView: YHServiceTableFootView!
    var sectionView: YHServiceSectionView!
    var id = 3
    var classId: Int = 0

    var dataSouce: [YHHomeListModel?] = [] {
        didSet {
            self.tableFootView.items = dataSouce
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

extension YHFourKingViewController {
    func loadData() {
        homeViewModel.getHomeClassify{[weak self] success, error in
            guard let self = self, let classify = self.homeViewModel.classify  else { return }
            for item in classify {
                let model = item as YHHomeClassifyModel
                if model.id == self.id {
                    if self.classId == 0 {
                        gk_navTitle = model.name
                        self.sectionView.items = model.children
                        if model.children.count == 1 {
                            self.updateAllView()
                        }
                        let classifyID = model.children.first?.id ?? 0
                        self.classId = classifyID
                        self.homeViewModel.getList(true, classifyID) {[weak self] success, error in
                            guard let self = self else { return }
                            self.dataSouce = self.homeViewModel.arrHomeNewsData ?? []
                            if self.homeViewModel.hasMoreForHomeNews == false {
                                self.tableFootView.myCollectView.es.noticeNoMoreData()
                                self.tableFootView.myCollectView.footer?.alpha = 1
                            }
                        }
                    }
                }
            }
        }
    }
     
    func updateAllView() {
        sectionView.snp.remakeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(0)
        }
        tableFootView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
        }
    }
    
    func setupUI() {
        gk_navBarAlpha = 1
        
        sectionView = {
            let view = YHServiceSectionView()
            view.block = {[weak self] model in
                guard let self = self else { return }
                self.tableFootView.myCollectView.es.resetNoMoreData()
                self.tableFootView.myCollectView.setContentOffset(CGPoint.zero, animated: false)
                self.classId = model.id
                self.homeViewModel.getList(true, model.id) {[weak self] success, error in
                    guard let self = self else { return }
                    self.dataSouce = self.homeViewModel.arrHomeNewsData ?? []
                    if self.homeViewModel.hasMoreForHomeNews == false {
                        self.tableFootView.myCollectView.es.noticeNoMoreData()
                        self.tableFootView.myCollectView.footer?.alpha = 1
                    }
                }
            }
            return view
        }()
        view.addSubview(sectionView)
        sectionView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(48)
        }
        
        tableFootView = YHServiceTableFootView()
        tableFootView.moreBlock = {[weak self] in
            guard let self = self else { return }
            self.homeViewModel.getList(false, self.classId) {[weak self] success, error in
                guard let self = self else { return }
                DispatchQueue.main.asyncAfter(wallDeadline: .now() + 0.35, execute: {
                    CATransaction.setDisableActions(true)
                    self.dataSouce = self.homeViewModel.arrHomeNewsData ?? []
                    CATransaction.commit()
                    self.tableFootView.myCollectView.es.stopLoadingMore()
                    if self.homeViewModel.hasMoreForHomeNews == false {
                        self.tableFootView.myCollectView.es.noticeNoMoreData()
                    }
                })
            }
        }
        view.addSubview(tableFootView)
        tableFootView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar + 48)
        }
    }
}
