//
//  YHHomeListModel.swift
//  galaxy
//
//  Created by EDY on 2024/4/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeListTotalModel: YHBaseModel {
    var data: [YHHomeListModel] = []
    var total: Int = 0
}

class YHHomeListModel: YHBaseModel {
    var collect_count: Int = 0
    var id: Int = 0
    var title: String = ""
    var content: String = ""
    var view_count: Int = 0 //浏览数量
    var img_url: String = ""
    var type: Int = 0 //文章类型 '文章类型 1视频 2图文 3图片',
    var is_like : Bool = false
    var media_url : String = ""
    var like_count : Int = 0 //点赞梳理
    
    
    
    //网络返回的图片宽高
    var img_width: CGFloat = 0
    var img_height: CGFloat = 0
    
    //实际使用的图片宽高
    var img_width_use : CGFloat = 0
    var img_height_use : CGFloat = 0
    
    //cell的宽高
    var img_width_cell : CGFloat = 0
    var img_height_cell : CGFloat = 0
    
    //描述的高度
    var textH : CGFloat = 16.0
    
    
    
    
    func calHeightParam() {
        let text = self.title
        let width = (KScreenWidth - 47) / 2
        let font = UIFont.PFSC_R(ofSize: 14) // 字体大小
        let maxWidth = width - 16 // 最大宽度限制
        // 创建NSAttributedString对象并设置属性
        let attributes = [NSAttributedString.Key.font : font] as [NSAttributedString.Key : Any]
        _ = NSMutableAttributedString(string: text, attributes: attributes)
        // 根据指定的最大宽度和字体大小计算文本的高度
        let size = (text as NSString).boundingRect(with: CGSize(width: maxWidth, height: .greatestFiniteMagnitude), options: .usesLineFragmentOrigin, attributes: attributes, context: nil).size
        var textHeight : CGFloat = size.height
        if textHeight > 40.0 {
            textHeight = 40.0
        } else if textHeight < 16 {
            textHeight = 16
        }
        self.textH = textHeight
        
        let imageSize = CGSizeMake(CGFloat(self.img_width), CGFloat(self.img_height))
        var imageHeight = 0.0
        if imageSize.width == 0 {
            imageHeight = width
        } else {
            imageHeight = width * imageSize.height/imageSize.width
            if imageHeight > 280 {
                imageHeight = 280
            } else if imageHeight < 140 {
                imageHeight = 140
            }
        }
        
        let totalHeight = imageHeight + textHeight + 30 + 16
        
        self.img_width_use = width
        self.img_height_use = imageHeight
        
        self.img_width_cell = width
        self.img_height_cell = totalHeight
    }
}
