//
//  YHAgreementAlertView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHAgreementAlertView: UIView {
    typealias UrlBlock = (_ url: String) -> ()
    var urlBlock: UrlBlock?
    
    typealias AgreeBlock = () -> ()
    var agreeBlock: AgreeBlock?
    var cancelBlock:AgreeBlock?
    
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
//        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
//        tap.delegate = self
//        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.left.equalTo(38)
            make.right.equalTo(-38)
        }
        
        titleLabel = {
            let label = UILabel()
            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.numberOfLines = 0
            label.text = "欢迎使用银河港生活"
            return label
        }()
        
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(kMargin)
        }
        
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor(hex: 0xF0F0F0)
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.height.equalTo(1)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        messageLabel = {
            let label = UILabel()
            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 16)
            label.numberOfLines = 0
            label.text = ""
            return label
        }()
        
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(lineView.snp.bottom).offset(kMargin)
        }
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0xffffff)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        let itemW = (KScreenWidth - kMargin * 2 - 10 - 38 * 2) / 2.0
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.top.equalTo(messageLabel.snp.bottom).offset(21)
            make.left.equalTo(kMargin)
            make.bottom.equalTo(-kMargin)
            make.height.equalTo(45)
            make.width.equalTo(itemW)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("确认", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.height.equalTo(disAgressButton.snp.height)
            make.top.equalTo(disAgressButton.snp.top)
            make.width.equalTo(itemW)
            make.left.equalTo(disAgressButton.snp.right).offset(10)
        }
        
        
        
        let a: ASAttributedString = .init("感谢您信任并使用银河港生活，我们将通过", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.mainTextColor))
        
        let aa: ASAttributedString = .init("《银河港生活隐私协议》", .font(UIFont.PFSC_M(ofSize: 16)),.foreground(UIColor.brandMainColor), .action {
            if let block = self.urlBlock {
                block(YHBaseUrlManager.shared.curPrivacyAgreementUrl())
            }
        })
        
        
        let and: ASAttributedString = .init("和", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.mainTextColor))
        
        
        let aab: ASAttributedString = .init("《银河港生活用户条款》", .font(UIFont.PFSC_M(ofSize: 16)),.foreground(UIColor.brandMainColor), .action {
            if let block = self.urlBlock {
                block(YHBaseUrlManager.shared.curUserItemsUrl())
            }
        })
        
        let aaa: ASAttributedString = .init("帮助您了解我们收集、使用、存储和共享个人信息的情况，特别是我们所采取的个人信息类型和用途的对应关系。此外，您还能了解到您所享受的相关权利以及实现途径。认真阅读之后，如您同意，请点击下方的按钮开始接受我们的服务。", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.mainTextColor))
        
        messageLabel.attributed.text = a + aa + and + aab + aaa
    }
    
    @objc func agree() {
        if let block = self.agreeBlock {
            block()
        }
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func disagree() {
        if let block = self.cancelBlock {
            block()
        }
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHAgreementAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
