//
//  YHHomeKingKongBlockView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeKingKongBlockView: UIView {
    static let viewH : CGFloat = 71.0
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var arrData : [YHHomeKingKongBlockModel] = [
        YHHomeKingKongBlockModel(type: "3", iconName: "kingkong_sffl", title: "身份福利"),
        YHHomeKingKongBlockModel(type: "4", iconName: "kingkong_blgl", title: "办理攻略"),
        YHHomeKingKongBlockModel(type: "5", iconName: "kingkong_khxs", title: "客户心声"),
        YHHomeKingKongBlockModel(type: "6", iconName: "kingkong_xgbs", title: "香港办事"),
    ]
}

private extension YHHomeKingKongBlockView {
    func initView() {
        let itemGap : CGFloat = (KScreenWidth - 20.0 * 2 - YHHomeKingKongBlockView.viewH * 4.0) / 3.0
        var offsetX : CGFloat = 0
        for (index,item) in arrData.enumerated() {
            let view = YHHomeKingKongBlockItem()
            view.dataModel = item
            addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalTo(offsetX)
                make.width.height.equalTo(YHHomeKingKongBlockView.viewH)
            }
            offsetX = offsetX + YHHomeKingKongBlockView.viewH + itemGap
            view.tag = index
            let tap = UITapGestureRecognizer(target: self, action: #selector(tapView(gestureRecognizer:)))
            view.addGestureRecognizer(tap)
        }
    }
    
    
    @objc func tapView(gestureRecognizer:UITapGestureRecognizer) {
        if let tag = gestureRecognizer.view?.tag {
            switch tag {
            case 0:
                let vc = YHFourKingViewController()
                vc.id = 3
                UIViewController.current?.navigationController?.pushViewController(vc)
            case 1:
                let vc = YHFourKingViewController()
                vc.id = 4
                UIViewController.current?.navigationController?.pushViewController(vc)
            case 2:
                let vc = YHFourKingViewController()
                vc.id = 5
                UIViewController.current?.navigationController?.pushViewController(vc)
            case 3:
                let vc = YHHKEventViewController()
                UIViewController.current?.navigationController?.pushViewController(vc)
            default:
                break
            }
        }
    }
}
