//
//  YHServiceCenterMainViewController.swift
//  galaxy
//
//  Created by EDY on 2023/12/20.
//

import UIKit
import JXSegmentedView
import AttributedString

//服务中心
class YHServiceCenterMainViewController: YHBaseViewController {
    
    private let serviceCenterMainReqVM : YHServiceCenterMainViewModel = YHServiceCenterMainViewModel()
    
    var titleLabel: UILabel!
    var nameBgImageView: UIImageView!
    var nameLabel: UILabel!
    var orderButton: UIButton!
    var orderId: Int = 0
    var mobile: String = ""
    var model: YHContactItemModel = YHContactItemModel()
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "service_center_head_bkg4")
        imagV.contentMode = .scaleAspectFill
        imagV.isUserInteractionEnabled = true
        return imagV
        
    }()
    
    private let noDataView : YHServiceNoOrderView = {
        let view = YHServiceNoOrderView()
        view.isHidden = true
        return view
    }()
    var controllerOne: YHServiceOrderListView = YHServiceOrderListView()
    var controllerTwo: YHServiceOrderListView = YHServiceOrderListView()
    var controllerThree: YHServiceOrderListView = YHServiceOrderListView()
    var controllerFour: YHServiceOrderListView = YHServiceOrderListView()
    var arrItemTitles = ["全部", "待开始", "进行中", "已完成"]
    var arrItemVCs: [YHServiceOrderListView] = []
    var segmentedView : JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: k_Height_safeAreaInsetsTop(), width: KScreenWidth, height: 48))
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.isTitleColorGradientEnabled = true
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleNormalColor = .labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = .mainTextColor
        
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 16
        return dataSource
    }()
    
    //分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .scrollView)
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupUI()
        addListView()

        noDataView.clickMoreBtnClickkBlock = {[weak self] in
            guard let self = self else { return }
            let vc = YHServiceViewController()
            vc.defaltIndex = 0
            self.navigationController?.pushViewController(vc)
        }
        noDataView.clickBackBtnClickBlock = {[weak self] in
            guard self != nil else { return }
            goTabBarBy(tabType: .home)
        }
        noDataView.clickShowBtnClickBlock = {
            YHServiceOrderAlertView.show()
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

extension YHServiceCenterMainViewController {
    func loadData() {
        serviceCenterMainReqVM.getContactList {[weak self] success, error in
            guard let self = self else { return }
            if success == true {
        
            } else {
                YHHUD.flash(message: error?.errorMsg ?? "请求出错")
            }
            self.handleRightUI()
        }
    }
    
    func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        view.addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(202)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "我的服务"
            label.font = UIFont.PFSC_M(ofSize: 21)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        view.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(53)
            make.left.equalTo(20)
            make.height.equalTo(29)
        }
        
        orderButton = {
            let button = UIButton(type: .custom)
            button.setTitle("我的订单", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.setTitleColor(UIColor(hex: 0x94a3b8), for: .normal)
            button.addTarget(self, action: #selector(pushOrderView), for: .touchUpInside)
            return button
        }()
        view.addSubview(orderButton)
        orderButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.equalTo(20)
            make.width.equalTo(56)
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()

        segmentedView.frame = CGRect(x: 4, y: k_Height_safeAreaInsetsTop() + 98, width: view.bounds.size.width - 8, height: 48)
        listContainerView.frame = CGRect(x: 0, y: k_Height_safeAreaInsetsTop() + 48 + 98, width: view.bounds.size.width, height: view.bounds.size.height - 48 - k_Height_safeAreaInsetsTop() - 98 - k_Height_TabBar)
    }
    
    @objc func pushOrderView() {
        let vc = YHOrderDetailViewController()
        vc.model = model
        self.navigationController?.pushViewController(vc)
    }
}

extension YHServiceCenterMainViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
//        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewDidEndDragging"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
//        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewWillBeginDragging"), object: nil)
    }
}

extension YHServiceCenterMainViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index]
    }
}


extension YHServiceCenterMainViewController {
    private func handleRightUI() {
        if serviceCenterMainReqVM.arrContactList.isEmpty {
            noDataView.isHidden = false
            nameBgImageView.isHidden = true
            segmentedView.isHidden = true
            listContainerView.isHidden = true
            orderButton.isHidden = true
        } else {
            guard let model = serviceCenterMainReqVM.arrContactList.first else {
                return
            }
            noDataView.isHidden = true
            nameBgImageView.isHidden = false
            segmentedView.isHidden = false
            listContainerView.isHidden = false
            orderButton.isHidden = false
            orderId = model.id
            mobile = model.mobile
            self.model = model
            UserDefaults.standard.set(orderId, forKey: "orderIdForPreview")
            UserDefaults.standard.synchronize()
            for i in 0..<arrItemTitles.count {
                let vc = arrItemVCs[i] as YHServiceOrderListView
                vc.type = i
                if i == 1 {
                    vc.type = 2
                }
                if i == 2 {
                    vc.type = 1
                }
                vc.orderID = orderId
                vc.mobile = mobile
                vc.loadData()
                vc.block = {[weak self] type, count in
                    guard let self = self else {
                        return
                    }
                    if type == 0 {
                        arrItemTitles[0] = "全部(\(count))"
                        
                    } else if type == 2 {
                        arrItemTitles[1] = "进行中(\(count))"
                                           
                    } else if type == 1 {
                        arrItemTitles[2] = "待开始(\(count))"
                                          
                    } else if type == 3 {
                        arrItemTitles[3] = "已完成(\(count))"
                    }
                    self.updata()
                }
            }
            segmentedView.dataSource = segmentedDataSource
            segmentedView.reloadData()
            serviceCenterMainReqVM.getPersonInfoFillStep(params: ["orderId":orderId]) {[weak self] success, error in
                guard let self = self else { return }
                var name = ""
                if let applicant = self.serviceCenterMainReqVM.informationFillStepModel {
                    if applicant.applicantName.isEmpty {
                        name = "尊敬的客户"
                    } else {
                        name = applicant.applicantName
                        if applicant.sex == 1 {
                            name = name + "先生"
                        } else if applicant.sex == 2 {
                            name = name + "女士"
                        } else {
                            
                        }
                    }
                }
                let a: ASAttributedString = .init("您好，\(name)，您当前处于", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor(hex: 0x121a26)))
                let aa: ASAttributedString = .init(NSAttributedString(string: "身份申请"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("阶段", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor(hex: 0x121a26)))
                self.nameLabel.attributed.text = a + aa + aaa
            }
        }
    }
    
    func addListView() {
        nameBgImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "service_name_bg")
            return view
        }()
        view.addSubview(nameBgImageView)
        nameBgImageView.snp.makeConstraints { make in
            make.top.equalTo(92)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(50)
        }
        
        nameLabel = {
            let label = UILabel()
            label.text = "您好，张先生，您当前处于身份申请阶段"
            label.font = UIFont.PFSC_M(ofSize: 12)
            label.textColor = UIColor.brandMainColor
            return label
        }()
        nameBgImageView.addSubview(nameLabel)
        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(21)
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.height.equalTo(17)
        }
        
        view.addSubview(noDataView)
        noDataView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(225)
        }
        
        controllerOne.type = 0
        controllerOne.orderID = orderId
        controllerOne.block = {[weak self] type, count in
            guard let self = self else { return }
            arrItemTitles[0] = "全部(\(count))"
            self.updata()
        }
        controllerTwo.type = 2
        controllerTwo.orderID = orderId
        controllerTwo.block = {[weak self] type, count in
            guard let self = self else { return }
            arrItemTitles[1] = "进行中(\(count))"
            self.updata()
        }
        controllerThree.type = 1
        controllerThree.orderID = orderId
        controllerThree.block = {[weak self] type, count in
            guard let self = self else { return }
            arrItemTitles[2] = "待开始(\(count))"
            self.updata()
        }
        controllerFour.type = 3
        controllerFour.orderID = orderId
        controllerFour.block = {[weak self] type, count in
            guard let self = self else { return }
            arrItemTitles[3] = "已完成(\(count))"
            self.updata()
        }
        arrItemVCs.append(controllerOne)
        arrItemVCs.append(controllerTwo)
        arrItemVCs.append(controllerThree)
        arrItemVCs.append(controllerFour)
        
        //segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        segmentedView.collectionView.backgroundColor = .white
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        
        //分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        //配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorColor = UIColor.brandMainColor
        indicator.indicatorCornerRadius = 0
        segmentedView.indicators = [indicator]
        segmentedView.backgroundColor = UIColor(red: 0.95, green: 0.95, blue: 0.95, alpha: 1)
        
        segmentedView.defaultSelectedIndex = 1
    }
    
    func updata(){
        DispatchQueue.main.async {
            self.segmentedDataSource.titles = self.arrItemTitles
            self.segmentedView.reloadData()
        }
    }
}

