//
//  YHCertificateEntryHeadView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHCertificateEntryHeadView: UIView {
    static let viewH : CGFloat = 77.0 + 17.0
    
    
    var dataModel : YHCertificateEntryModel? {
        didSet {
            updateUI()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var nameLable : UILabel = {
        let titleLable = UILabel(text: "")
        titleLable.font = UIFont.PFSC_B(ofSize: 21)
        titleLable.textColor = UIColor.mainTextColor
        titleLable.lineBreakMode = .byTruncatingMiddle
        return titleLable
    }()
    
    
    private lazy var statiticLable : UILabel = {
        let titleLable = UILabel(text: "待上传0件，已驳回0件，审核中0件，已完成0件")
        titleLable.font = UIFont.PFSC_R(ofSize: 13)
        titleLable.textColor = UIColor.mainTextColor
        return titleLable
    }()
    
}

private extension YHCertificateEntryHeadView {
    func initView() {
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalTo(21)
            make.height.equalTo(30)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        addSubview(statiticLable)
        statiticLable.snp.makeConstraints { make in
            make.top.equalTo(nameLable.snp.bottom).offset(6)
            make.height.equalTo(20)
            make.left.equalTo(nameLable.snp.left)
            make.right.equalTo(nameLable.snp.right)
        }
        
        let a: ASAttributedString = .init("待上传", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let aa: ASAttributedString = .init("0", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let b: ASAttributedString = .init("件，已驳回", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("0", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let c: ASAttributedString = .init("件，审核中", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let cc: ASAttributedString = .init("0", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let d: ASAttributedString = .init("件，已完成", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let dd: ASAttributedString = .init("0", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let e: ASAttributedString = .init("件", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        statiticLable.attributed.text = a + aa + b + bb + c + cc + d + dd + e

    }
    
    func updateUI() {
        guard let dataModel = dataModel else { return }
        var tmp = ""
        if dataModel.user_name.isEmpty {
            tmp = "尊敬的客户"
        } else {
            tmp = dataModel.user_name
            if dataModel.sex == 1 {
                tmp = tmp + "先生"
            } else if dataModel.sex == 2 {
                tmp = tmp + "女士"
            } else {
                
            }
        }
        nameLable.text = "您好," + tmp
        
        let a: ASAttributedString = .init("待上传", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let aa: ASAttributedString = .init(NSAttributedString(string: String(dataModel.to_be_submit_num)), .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let b: ASAttributedString = .init("件，已驳回", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init(NSAttributedString(string: String(dataModel.reject_num)), .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let c: ASAttributedString = .init("件，审核中", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let cc: ASAttributedString = .init(NSAttributedString(string: String(dataModel.to_be_audit_num)), .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let d: ASAttributedString = .init("件，已完成", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        let dd: ASAttributedString = .init(NSAttributedString(string: String(dataModel.pass_num)), .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.warnColor))
        
        
        let e: ASAttributedString = .init("件", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor))
        statiticLable.attributed.text = a + aa + b + bb + c + cc + d + dd + e
    }
}
