//
//  YHSchemeHeadTotalScoreView.swift
//  galaxy
//
//  Created by EDY on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSchemeHeadTotalScoreView: UIView {
    var titleLabel: UILabel!
    var scoreLabel: UILabel!
    var scoreUnitLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(hex: 0xcf9764).withAlphaComponent(0.12)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.text = "总分"
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.bottom.equalToSuperview()
        }
        
        scoreUnitLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .right
            label.text = "分"
            return label
        }()
        addSubview(scoreUnitLabel)
        scoreUnitLabel.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        scoreLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 24)//UIFont(name: "AlibabaPuHuiTi-Bold", size: 24)
            label.textColor = UIColor(hex: 0xd48638)
            label.textAlignment = .right
            label.text = "-"
            return label
        }()
        addSubview(scoreLabel)
        scoreLabel.snp.makeConstraints { make in
            make.right.equalTo(-34)
            make.top.bottom.equalToSuperview()
        }
    }
    
    func setScore(_ score: String) {
        scoreLabel.text = score
    }
}
