//
//  YHSchemeTableFooterView.swift
//  galaxy
//
//  Created by EDY on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSchemeTableFooterView: UIView {
    var centerView: UIView!
    var leftLineImageView: UIImageView!
    var rightLineImageView: UIImageView!
    var logoImageView: UIImageView!

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(hex: 0x070E33)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.masksToBounds = true
            view.layer.cornerRadius = kCornerRadius8
            view.layer.maskedCorners = [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.right.equalTo(-8)
            make.top.equalToSuperview()
            make.bottom.equalTo(-55)
        }
        
        logoImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_foot_logo")
            return view
        }()
        centerView.addSubview(logoImageView)
        logoImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(17)
            make.width.equalTo(90)
            make.bottom.equalTo(-19)
        }
        
        leftLineImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_foot_left")
            return view
        }()
        centerView.addSubview(leftLineImageView)
        leftLineImageView.snp.makeConstraints { make in
            make.right.equalTo(logoImageView.snp.left).offset(-10)
            make.height.equalTo(3)
            make.width.equalTo(92)
            make.bottom.equalTo(-21)
        }
        
        rightLineImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_foot_right")
            return view
        }()
        centerView.addSubview(rightLineImageView)
        rightLineImageView.snp.makeConstraints { make in
            make.left.equalTo(logoImageView.snp.right).offset(10)
            make.height.equalTo(3)
            make.width.equalTo(92)
            make.bottom.equalTo(-21)
        }
    }
}
