//
//  YHMySignatureDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySignatureDetailViewModel: YHBaseViewModel {
    var mainModel: YHMySignatureDetailModel?
    var pageUrl: String?
    var personalUrl: String?
    
    override init() {
        super.init()
    }
    
    func requestSignatureDetail(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.detail
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureDetailModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePageURL(_ id: String, callBackBlock:@escaping (_ success: Bool?, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.pageUrl
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
//                let dic = json.data
//                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
//                    callBackBlock(false,nil)
//                    return
//                }
                self.pageUrl = json.data as? String
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalURL(callBackBlock:@escaping (_ success: Bool?, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        let _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignCallBack(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.callBack
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureLook(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.look
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                self.pageUrl = json.data as? String
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureDownload(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.download
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignConfirm(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.confirm
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestFileAction(_ id: String, _ type: Int, _ newArray: [String], _ oldUrl: String,callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id,
                                      "op_type": type,
                                      "new_url": newArray,
                                      "old_url": oldUrl]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.upload
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
//                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
//                    callBackBlock(false,nil)
//                    return
//                }
//                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDocs(_ params : [String : Any], callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.sendMail
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignBack(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.signCallBack
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCheckPersonalStatus(_ id: String) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personal
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, code in
        } failBlock: { err in
        }
    }
}
