//
//  YHCollegeSearchBar.swift
//  galaxy
//
//  Created by edy on 2024/2/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCollegeSearchBar: UIView {

    static let height = 40.0
    static let confirmBtnHeight = height-8.0
    
    var textChange:((String?)->Void)?
    var confirmBlock:(()->Void)?
    var placeHolder:String? {
        didSet {
            if let placeholder = placeHolder {
                textField.attributedPlaceholder = NSAttributedString(string: placeholder, attributes: [NSAttributedString.Key.foregroundColor : UIColor.placeHolderColor])
            }
        }
    }
    private lazy var contentView = {
        let view = UIView()
        view.backgroundColor = .contentBkgColor
        view.layer.cornerRadius = Self.height/2.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var textField:UITextField = {
        let textField = UITextField()
        textField.backgroundColor = .clear
        textField.attributedPlaceholder = NSAttributedString(string: "请输入学校全称", attributes: [NSAttributedString.Key.foregroundColor : UIColor.placeHolderColor])
        textField.font = UIFont.PFSC_M(ofSize: 12)
        textField.tintColor = UIColor.brandMainColor
        textField.textColor = UIColor.mainTextColor
        textField.addTarget(self, action: #selector(textFieldChanged(textField:)), for: .editingChanged)
        return textField
    }()
    
    lazy var confirmBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("确认".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.layer.cornerRadius = Self.confirmBtnHeight/2.0
        btn.addTarget(self, action: #selector(confirmBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.createUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    static func createBar() -> YHCollegeSearchBar {
        let view = YHCollegeSearchBar(frame: CGRect(x: 0, y: 0, width: KScreenWidth-32, height: height))
        return view
    }
    
    @objc func confirmBtnClicked() {
        if let confirmBlock = confirmBlock {
            confirmBlock()
        }
    }
    
    func createUI() {
        
        self.backgroundColor = .white
        
        contentView.addSubview(textField)
        contentView.addSubview(confirmBtn)
        self.addSubview(contentView)
        
        contentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        textField.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(Self.height/2.0)
            make.right.equalTo(confirmBtn.snp.left).offset(-4)
            make.centerY.equalToSuperview()
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 66, height: Self.height-8.0))
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-4)
        }
    }
    
    @objc func textFieldChanged(textField:UITextField) {
        let text = textField.text ?? ""
        let max = 100
        textField.text = (text.count > max ? text[safe: ..<max] : text)
        if let textChange = textChange {
            textChange(textField.text)
        }
    }
}
