//
//  YHPreviewWorkExpViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *工作经验 预览
 */
class YHPreviewWorkExpViewController: YHPreviewBaseViewController {
    private let previewVM : YHPreviewViewModel =  YHPreviewViewModel()
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
}

private extension YHPreviewWorkExpViewController {
    func setupUI() {
        self.homeTableView.register(YHPreviewInfoCell.self,forCellReuseIdentifier: YHPreviewInfoCell.cellReuseIdentifier)
        self.homeTableView.reloadData()
    }
    
    
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            previewVM.getPreviewForWorkExpInfo(params: ["order_id" : orderID]) { success, error in
                if success == true {
                    
                } else {
                    
                }
                self.homeTableView.reloadData()
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
}



// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHPreviewWorkExpViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return previewVM.arrDataForWorkExpInfo.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHPreviewInfoCell.self)
        cell.selectionStyle = .none
        cell.model = previewVM.arrDataForWorkExpInfo[indexPath.row]
        return cell
    }
}
