//
//  YHPersonInfoIdentificationCardView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoCertificatePictureItemView: UIView {
    lazy var requestVM : YHBaseViewModel =  {
        let r = YHBaseViewModel()
        return r
    }()
    
    var dataModel : YHPersonInfoCellModel2? {
        didSet {
            updateUI()
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var cellTitleLable : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 14)
        return lable
    }()
    
    
    private lazy var frontImagV : UIImageView = {
        let lable = UIImageView()
        lable.image = UIImage(named: "person_info_id_front")
        lable.contentMode = .scaleAspectFit
        lable.layer.cornerRadius = kCornerRadius6
        lable.clipsToBounds = true
        return lable
    }()
    
    
    private lazy var backImagV : UIImageView = {
        let lable = UIImageView()
        lable.image = UIImage(named: "person_info_id_back")
        lable.contentMode = .scaleAspectFit
        lable.layer.cornerRadius = kCornerRadius6
        lable.clipsToBounds = true
        return lable
    }()
    
    
    private lazy var frontLable : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "身份证头像面"
        lable.textAlignment = .center
        return lable
    }()
    
    
    private lazy var backLable : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "身份证国徽面"
        lable.textAlignment = .center
        return lable
    }()
    
    
    lazy var bottomLine : UIView = {
        let lable = UIView()
        lable.backgroundColor = UIColor(hex: 0xF0F0F0)
        return lable
    }()
}


extension YHPreviewInfoCertificatePictureItemView {
    func setupUI() {
        addSubview(cellTitleLable)
        cellTitleLable.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(20)
        }
        
        
        addSubview(frontLable)
        frontLable.snp.makeConstraints { make in
            make.top.equalTo(cellTitleLable.snp.bottom).offset(18)
            make.height.equalTo(20)
            make.left.equalTo(cellTitleLable.snp.left)
            make.right.equalTo(self.snp.centerX).offset(-4)
        }
        
        addSubview(frontImagV)
        frontImagV.snp.makeConstraints { make in
            make.top.equalTo(frontLable.snp.bottom).offset(11)
            make.height.equalTo(95)
            make.left.equalTo(frontLable.snp.left)
            make.right.equalTo(frontLable.snp.right)
        }
        
        
        
        addSubview(backLable)
        backLable.snp.makeConstraints { make in
            make.top.equalTo(frontLable.snp.top)
            make.height.equalTo(20)
            make.right.equalTo(-18)
            make.left.equalTo(self.snp.centerX).offset(4)
        }
        
        
        addSubview(backImagV)
        backImagV.snp.makeConstraints { make in
            make.top.equalTo(backLable.snp.bottom).offset(11)
            make.height.equalTo(95)
            make.left.equalTo(backLable.snp.left)
            make.right.equalTo(backLable.snp.right)
        }
        
        
        
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.top.equalTo(backImagV.snp.bottom).offset(15.5)
            make.height.equalTo(0.5)
            make.left.right.equalToSuperview()
            
            make.bottom.equalToSuperview()
        }
    }
}


extension YHPreviewInfoCertificatePictureItemView {
    func updateUI() {
        guard let dataModel = dataModel else { return  }
        cellTitleLable.text = dataModel.cellTitle
        frontLable.text = dataModel.idType == 1 ? "身份证头像面" : "港澳通行证正面"
        backLable.text = dataModel.idType == 1 ? "身份证国徽面" : "港澳通行证反面"
        
        //获取头像
        handleCardImage()
    }
    
    
    private func handleCardImage() {
        guard let dataModel = dataModel else { return }
        
        let url = dataModel.frontUrl
//        let url = "https://upload-cdn.galaxy-immi.com/crm/test/files/1709370416082.png?Expires=1709697934&OSSAccessKeyId=LTAI5tJPQC4La6LWbcNoz61u&Signature=eKv4J8STMXSHFyJvozmHPgJdmY4%3D&v=1709696134"
        if url.isEmpty == false {
            self.requestVM.getPublicImageUrl(url) {[weak self] success, error in
                guard let self = self else { return }
                guard success != nil else { return }
                self.frontImagV.kf.setImage(with: URL(string: success))
            }
        }
        
        
//        let url2 = "https://upload-cdn.galaxy-immi.com/crm/test/files/1709370416082.png?Expires=1709697934&OSSAccessKeyId=LTAI5tJPQC4La6LWbcNoz61u&Signature=eKv4J8STMXSHFyJvozmHPgJdmY4%3D&v=1709696134"
        let url2 = dataModel.backUrl
        if url2.isEmpty == false {
            self.requestVM.getPublicImageUrl(url2) {[weak self] success, error in
                guard let self = self else { return }
                guard success != nil else { return }
                self.backImagV.kf.setImage(with: URL(string: success))
            }
        }
    }
}


