//
//  YHWorkFileItemView.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWorkFileClickType {
    case delete
    case click
}

class YHWorkFileItemView: UIView {
    typealias ItemBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> ()
    var block: ItemBlock?
    var titleLabel: UIButton!
    var deleteButton: UIButton!
    
    var dataSource: YHWorkExperienceFileModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UIButton(type: .custom)
            label.setTitleColor(UIColor.mainTextColor, for: .normal)
            label.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            label.addTarget(self, action: #selector(itemClick), for: .touchUpInside)
            label.contentHorizontalAlignment = .left
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(16)
            make.width.equalTo(200)
            make.height.equalTo(20)
        }
        
        deleteButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.contentHorizontalAlignment = .right
            button.setTitle("删除", for: .normal)
            button.setTitleColor(.red, for: .normal)
            button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
            return button
        }()
        addSubview(deleteButton)
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(28)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.setTitle(dataSource.fileName, for: .normal)
    }
    
    @objc func itemClick() {
        if let block = block, let dataSource = dataSource {
            block(dataSource, .click)
        }
    }
    
    @objc func deleteClick() {
        if let block = block, let dataSource = dataSource {
            block(dataSource, .delete)
        }
    }
}
