//
//  YHWorkIntroductionTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkIntroductionTableViewCell: UITableViewCell {
    typealias ExperienceListBlock = (_ model: YHWorkExperienceProjectModel) -> ()
    typealias IsMoreBlock = (_ isMore: Bool) -> ()
    typealias AddIntroductionBlock = () -> ()
    var clickBlock: ExperienceListBlock?
    var deleteBlock: ExperienceListBlock?
    var addIntroductionBlock: AddIntroductionBlock?
    var isMoreBlock: IsMoreBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var cannalButton: UIButton!
    var moreButton: UIButton!
    var mainItemView: UIView!
    var bottomView: YHWorkItemAddView!
    var dataSource: [YHWorkExperienceProjectModel]?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 16)
            label.text = "项目介绍(选填)"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(23)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        cannalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消操作", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(cannal), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "work_more"), for: .normal)
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(24)
            make.width.equalTo(24)
        }
        
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-65)
            make.top.equalTo(85)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("新增项目".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.addIntroductionBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(76 * i)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            let itemView = YHWorkIntroductionItemView()
            itemView.dataSource = dataSource?[i]
            itemView.tag = 4000 + i
            itemView.clickBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.clickBlock {
                    block(model)
                }
            }
            
            itemView.deleteBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.deleteBlock {
                    block(model)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(76 * i + 1)
                make.height.equalTo(75)
                make.right.equalTo(-18)
            }
        }
    }
    
    @objc func cannal() {
        moreButton.isHidden = false
        cannalButton.isHidden = true
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHWorkIntroductionItemView
            view.isShowDelete(isShow: false)
        }
        if let block = isMoreBlock {
            block(false)
        }
    }
    
    @objc func more() {
        moreButton.isHidden = true
        cannalButton.isHidden = false
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHWorkIntroductionItemView
            view.isShowDelete(isShow: true)
        }
        if let block = isMoreBlock {
            block(true)
        }
    }
}
