//
//  YHInformationFillTipsAlertView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit


var gloabView : YHInformationFillTipsAlertView?

class YHInformationFillTipsAlertView: UIView {
    typealias Block = (Bool) -> ()
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    //头部背景图片
    lazy var headBkgImagV: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "submit_success_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    //头部背景图片
    lazy var successIcon: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "submit_success_icon")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .plain)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = true
        tableView.rowHeight = UITableView.automaticDimension
        //        tableView.estimatedRowHeight = 100
        tableView.register(YHInformationFillTipsCell.self,forCellReuseIdentifier: YHInformationFillTipsCell.cellReuseIdentifier)
        return tableView
    }()
    
    //类方法 - 展示
    static func showCheckView(callBack: @escaping Block) {
        let view = YHInformationFillTipsAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
        
        gloabView = view
    }
    
    //类方法 隐藏
    static func hideCheckView() {
        guard let view = gloabView else { return }
        view.dismiss()
    }
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            view.clipsToBounds = true
            return view
        }()
        addSubview(centerView)
        
        let viewH = KScreenHeight > 680 ? 680 : (KScreenHeight - 64)
        centerView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(viewH)
        }
        
        
        let bottomView = UIView()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(96)
        }
        
//        bottomView.backgroundColor = .red //for test hjl
        
        let checkBtn = UIButton(type: .custom)
        checkBtn.addTarget(self, action: #selector(onClickReadyBtn), for: .touchUpInside)
        checkBtn.setTitle("准备完毕", for: .normal)
        checkBtn.setTitleColor(.white, for: .normal)
        checkBtn.layer.cornerRadius = kCornerRadius3
        checkBtn.clipsToBounds = true
        checkBtn.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        
        bottomView.addSubview(checkBtn)
        checkBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(48)
        }
        checkBtn.layoutIfNeeded()//非常重要！！！！ 
        checkBtn.addYinHeGradualLayer()
        
        
        let topView = UIView()
        topView.backgroundColor = .white
        topView.layer.zPosition = 1
        centerView.addSubview(topView)
        topView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
        }
        
        
        let lable01 = UILabel(text: "信息填写提示")
        lable01.textAlignment = .center
        lable01.font = UIFont.PFSC_M(ofSize: 17)
        lable01.textColor = UIColor.mainTextColor
        
        topView.addSubview(lable01)
        lable01.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.centerX.equalToSuperview()
            make.height.equalTo(24)
        }
        
        let closeBtn : UIButton = UIButton(type: .custom)
        closeBtn.setImage(UIImage(named: "person_info_close_btn"), for: .normal)
        closeBtn.setImage(UIImage(named: "person_info_close_btn"), for: .highlighted)
        topView.addSubview(closeBtn)
        closeBtn.addTarget(self, action: #selector(clickCloseBtn), for: .touchUpInside)
        closeBtn.snp.makeConstraints { make in
            make.centerY.equalTo(lable01.snp.centerY)
            make.right.equalTo(-25)
            make.width.height.equalTo(24)
        }
        
        closeBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        topView.addSubview(line)
        line.snp.makeConstraints { make in
            make.top.equalTo(lable01.snp.bottom).offset(12)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
        
        
        //middle view
        let middleView = UIView()
        centerView.addSubview(middleView)
        middleView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(topView.snp.bottom).offset(-20)
            make.bottom.equalTo(bottomView.snp.top)
        }
        
        middleView.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        homeTableView.delegate = self
        homeTableView.dataSource = self
        
        let footer = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 34))
        homeTableView.tableFooterView = footer
        
        let lable00 = UILabel(text: "我确认我所提供的材料真实有效，并知悉其中内容。")
        lable00.font = UIFont.PFSC_R(ofSize: 12)
        lable00.textColor = UIColor.labelTextColor2
        let tap = UITapGestureRecognizer(target: self, action: #selector(onClickAgree))
        lable00.isUserInteractionEnabled = true
        lable00.addGestureRecognizer(tap)

        footer.addSubview(lable00)
        lable00.snp.makeConstraints { make in
            make.left.equalTo(41)
            make.right.equalTo(-16)
            make.height.equalTo(20)
            make.top.equalTo(8)
        }

        let selectedBtn = UIButton(type: .custom)
        selectedBtn.setImage(UIImage(named: "login_privacy_disagree"), for: .normal)
        selectedBtn.setImage(UIImage(named: "login_privacy_agree"), for: .selected)
        selectedBtn.addTarget(self, action: #selector(onClickAgree), for: .touchUpInside)
        footer.addSubview(selectedBtn)
        selectedBtn.snp.makeConstraints { make in
            make.centerY.equalTo(lable00)
            make.left.equalTo(21)
            make.height.width.equalTo(12)
        }
        agreeButton = selectedBtn
        agreeButton.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
    }
    
    @objc func onClickReadyBtn() {
        
        if agreeButton.isSelected == true {
            block?(true)
        } else {
            YHHUD.flash(message: "请先勾选确认知悉内容")
        }
    }
    
    @objc func clickCloseBtn() {
        dismiss()
    }
    
    @objc func onClickAgree() {
        agreeButton.isSelected = !agreeButton.isSelected
    }
    
    
    @objc func agree() {
        block?(true)
    }
    
    @objc func disagree() {
        block?(false)
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHInformationFillTipsAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHInformationFillTipsAlertView : UITableViewDelegate,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHInformationFillTipsCell.self)
        cell.selectionStyle = .none
        return cell
    }
}
