//
//  YHSubmitAllInfoCheckView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSubmitAllInfoCheckView: UIView {
    typealias Block = (Bool) -> ()
    var block: Block?
    var centerView: UIView!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    static func showCheckView(tipMsg: String?,callBack: @escaping Block) {
        let view = YHSubmitAllInfoCheckView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        view.messageLabel.text = tipMsg ?? "--"
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
    
        
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(165)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "确定是否提交信息？提交后将不能修改"
            label.font = UIFont.PFSC_R(ofSize: 16)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(40)
        }
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  .white
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("确认", for: .normal)
            button.clipsToBounds = true
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.right.equalTo(-kMargin)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        agreeButton.layoutIfNeeded()
        agreeButton.addYinHeGradualLayer()
        agreeButton.addYinHeGradualLayer()
        
    }
    
    @objc func agree() {
        block?(true)
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func disagree() {
        block?(false)
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHSubmitAllInfoCheckView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
