//
//  YHCodeResultViewController.swift
//  galaxy
//
//  Created by EDY on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit

class YHCodeResultViewController: YHBaseViewController {
    var time = 60
    
    var bgImageView: UIImageView!
    var loginTitleLabel: UILabel!
    var loginSubTitleLabel: UILabel!
    var phoneLabel: UILabel!
    var getCodeLabel: UILabel!
    var getCodeButton: UIButton!
    var smscodeView: YHSmsCodeInputView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        // Do any additional setup after loading the view.
        startClicked()
    }
    
    func setView() {
        bgImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "login_bg_image")
            return imageView
        }()
        view.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalTo(view)
        }
        loginTitleLabel = {
            let label = UILabel()
            label.text = "登录后更精彩"
            label.font = UIFont.PFSC_M(ofSize: 32)
            label.textColor = UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(loginTitleLabel)
        loginTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.top.equalTo(111)
            make.height.equalTo(39)
        }
        loginSubTitleLabel = {
            let label = UILabel()
            label.text = "香港美好生活期待与你的相遇"
            label.font = UIFont.PFSC_R(ofSize: 20)
            label.textColor =  UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(loginSubTitleLabel)
        loginSubTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.top.equalTo(159)
            make.height.equalTo(24)
        }
        phoneLabel = {
            let label = UILabel()
            label.text = "已发送验证码至13352933800"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textAlignment = .left
            label.textColor =  UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(phoneLabel)
        phoneLabel.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.right.equalTo(-33)
            make.top.equalTo(242)
            make.height.equalTo(20)
        }
        
        smscodeView = {
            let view = YHSmsCodeInputView(config: YHSmsCodeViewConfig())
            view.complete = { [weak self] code in
                self?.navigationController?.popToRootViewController(animated: true)
            }
            return view
        }()
        view.addSubview(smscodeView)
        smscodeView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(288)
            make.height.equalTo(55)
        }
        
        getCodeLabel = {
            let button = UILabel()
            button.font = UIFont.PFSC_M(ofSize: 16)
            button.text = "重新发送（58s）"
            button.textColor = UIColor(hex:0xffffff)
            button.isHidden = false
            return button
        }()
        view.addSubview(getCodeLabel)
        getCodeLabel.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.top.equalTo(363)
            make.height.equalTo(20)
            make.width.equalTo(200)
        }
        
        getCodeButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .left
            button.setTitle("重新获取验证码", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.addTarget(self, action: #selector(startClicked), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        view.addSubview(getCodeButton)
        getCodeButton.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.top.equalTo(363)
            make.height.equalTo(20)
            make.width.equalTo(200)
        }
        
        //测试
        
    }
    
    @objc func startClicked() {
        getCodeLabel.isHidden = false
        getCodeButton.isHidden = true
        let sourceTimer = DispatchSource.makeTimerSource()
        sourceTimer.schedule(deadline: DispatchTime.now(), repeating: DispatchTimeInterval.milliseconds(1000), leeway: DispatchTimeInterval.milliseconds(0))
        sourceTimer.setEventHandler {
            if self.time != 0 {
                self.time -= 1
                DispatchQueue.main.async {
                    self.getCodeLabel?.text = String.localizedStringWithFormat("重新发送（%ds）",self.time)
                }
            } else if self.time <= 0 {
                sourceTimer.cancel()
                DispatchQueue.main.async {
                    self.time = 60
                    self.getCodeLabel.isHidden = true
                    self.getCodeButton.isHidden = false
                }
            }
        }
        // 启动定时器
        sourceTimer.resume()
    }
    
}
