//
//  YHPhoneLoginViewController.swift
//  galaxy
//
//  Created by EDY on 2024/2/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift

class YHPhoneLoginViewController: YHBaseViewController {
    
    var bgImageView: UIImageView!
    var closeButton: UIButton!
    var logImageView: UIImageView!
    var loginTitleLabel: UILabel!
    var loginSubTitleLabel: UILabel!
    var phoneMessageView: YHPhoneMessageView!
    var getCodeButton: UIButton!
    var privacyView: YHLoginPrivacyView!
    var viewModel: YHLoginViewModel?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        viewModel = YHLoginViewModel()
        setView()
        gk_navBackgroundColor = .clear
        gk_navShadowColor = .clear
        gk_navigationBar.isHidden = true
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        YHAnalytics.timeStrat("loginTime")
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        YHAnalytics.timeEnd("loginTime")
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
    }
    
    func setView() {
        view.backgroundColor = .white
        bgImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "login_phone_bg_image")
            imageView.isUserInteractionEnabled = true
            return imageView
        }()
        view.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.left.right.top.equalTo(view)
            make.height.equalTo(300)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "login_close"), for: .normal)
            button.addTarget(self, action: #selector(close), for: .touchUpInside)
            return button
        }()
        view.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.left.equalTo(13)
            make.top.equalTo(51)
            make.width.height.equalTo(30)
        }
        
        logImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "login_icon")
            imageView.layer.masksToBounds = true
            imageView.layer.cornerRadius = kCornerRadius8
            return imageView
        }()
        view.addSubview(logImageView)
        logImageView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.width.height.equalTo(53)
            make.top.equalTo(120)
        }
        loginTitleLabel = {
            let label = UILabel()
            label.text = "手机号登录"
            label.font = UIFont.PFSC_M(ofSize: 28)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        view.addSubview(loginTitleLabel)
        loginTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(203)
            make.height.equalTo(25)
        }
        
        loginSubTitleLabel = {
            let label = UILabel()
            label.text = "手机号首次登录自动注册"
            label.font = UIFont.PFSC_R(ofSize: 13)
            label.textColor =  UIColor.placeHolderColor
            return label
        }()
        view.addSubview(loginSubTitleLabel)
        loginSubTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(233)
            make.height.equalTo(20)
        }
        
        phoneMessageView = {
            let view = YHPhoneMessageView()
            view.backgroundColor =  UIColor.contentBkgColor
            view.layer.cornerRadius = kCornerRadius6
            view.layer.borderWidth = 1
            view.layer.borderColor = UIColor(hex:0xebeef4).cgColor
            view.phoneBlock = {[weak self] count in
                guard let self = self else { return }
                if count == 0 {
                    self.getCodeButton.backgroundColor =  UIColor.brandMainColor.withAlphaComponent(0.4)
                    self.getCodeButton.isEnabled = false
                } else {
                    self.getCodeButton.backgroundColor =  UIColor.brandMainColor
                    self.getCodeButton.isEnabled = true
                }
            }
            return view
        }()
        view.addSubview(phoneMessageView)
        phoneMessageView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(300)
            make.height.equalTo(56)
        }
        
        getCodeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor.withAlphaComponent(0.4)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("获取验证码", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(getCode), for: .touchUpInside)
            button.isEnabled = false
            return button
        }()
        view.addSubview(getCodeButton)
        getCodeButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(376)
            make.height.equalTo(48)
        }
        
        privacyView = {
            let view = YHLoginPrivacyView()
            return view
        }()
        view.addSubview(privacyView)
        privacyView.snp.makeConstraints { make in
            make.top.equalTo(442)
            make.left.equalTo(25)
            make.height.equalTo(20)
            make.width.equalTo(260)
        }
        //测试
    }
    
    @objc func getCode() {
        
        IQKeyboardManager.shared.resignFirstResponder()
        
        let phoneNumer = phoneMessageView.phoneTextField.text ?? ""
        guard phoneNumer.isMobile() == true else {
            YHHUD.flash(message: "请输入正确的手机号")
            return
        }
        if privacyView.isAgree {
            YHHUD.show(.progress(message: ""))
            viewModel?.getLoginCode(phoneNumer, callBackBlock: {[weak self] success,error in
                YHHUD.hide()
                
                guard let self = self else { return }
                
                if success == true {
                    let vc = YHCodeSueecssViewController()
                    vc.phoneNumber = self.phoneMessageView.phoneTextField.text
                    self.navigationController?.pushViewController(vc)
                } else {
                    var msg = error?.errorMsg ?? ""
                    if msg.isEmpty {
                        msg = String(error?.errorCode ?? 404)
                    }
                    YHHUD.flash(message: msg)
                }
            })
        } else {
            let view = YHPrivacyAlertView(frame: view.bounds)
            view.urlBlock = { [weak self] (type,url) in
                guard let self = self else { return }
                let vc = YHWebViewViewController()
                vc.url = url
                if type == 0 {
                    vc.navTitle = "银河港生活隐私政策"
                } else if type == 1 {
                    vc.navTitle = "银河港生活用户条款"
                }
                
                self.navigationController?.pushViewController(vc)
            }
            view.agreeBlock = { [weak self] in
                guard let self = self else { return }
                self.privacyView.isAgree = true
                self.getCode()
            }
            self.view.addSubview(view)
        }
    }
    
    @objc func close() {
        YHLoginManager.shared.loginSuccessActionBlock = nil
        self.dismiss(animated: true)
    }
}
