//
//  YHPhoneMessageView.swift
//  galaxy
//
//  Created by EDY on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit

class YHPhoneMessageView: UIView {
    typealias PhoneBlock = (_ count: Int) -> ()
    typealias Block = () -> ()
    var block: Block?
    var phoneBlock: PhoneBlock?
    var messageButton: UIButton!
    var pointImageView: UIImageView!
    var phoneTextField: UITextField!
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        messageButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.setTitle("+86", for: .normal)
            button.setTitleColor( UIColor(hex:0x000000), for: .normal)
            button.addTarget(self, action: #selector(messageClick), for: .touchUpInside)
            return button
        }()
        addSubview(messageButton)
        messageButton.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(16)
        }
        
        pointImageView = {
            let button = UIImageView()
            button.image = UIImage(named: "login_phone_point")
            return button
        }()
        addSubview(pointImageView)
        pointImageView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(60)
            make.width.equalTo(5)
            make.height.equalTo(2.83)
        }
        
        phoneTextField = {
            let text = UITextField()
            text.placeholder = "请输入签约手机号"
            text.font = UIFont.PFSC_R(ofSize: 16)
            text.textColor = UIColor(hex:0x000000)
            text.textAlignment = .left
            text.keyboardType = .phonePad
            text.clearButtonMode = .always
            text.delegate = self
            text.addTarget(self, action: #selector(textFeildChange), for: .allEvents)
            return text
        }()
        addSubview(phoneTextField)
        phoneTextField.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(70)
            make.right.equalTo(-22.5)
        }
    }
    
    @objc func messageClick() {
        if let block = block {
            block()
        }
    }
    
    @objc func textFeildChange() {
        if let block = phoneBlock {
            block(phoneTextField.text?.count ?? 0)
        }
    }
}

extension YHPhoneMessageView: UITextFieldDelegate {
    func textFieldDidEndEditing(_ textField: UITextField) {
        
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let newText = (textField.text! as NSString).replacingCharacters(in: range, with: string)
        if newText.count > 11 {
            return false
        }
        return true
    }
}
