//
//  YHPersonalCenterCell.swift
//  galaxy
//
//  Created by edy on 2023/12/20.
//

import UIKit
import SnapKit

class YHPersonalCenterCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHPersonalCenterCell"
    static let redPointWidth = 6.0
    
    lazy var iconImgView:UIImageView = {
        let icon = UIImageView(image: UIImage(named: "mine_manager"))
        return icon
    }()
    
    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString:"#141414")
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize:15)
        return label
    }()
    
    lazy var redPointView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xF81D22)
        view.layer.cornerRadius = Self.redPointWidth/2.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var arrowImgView:UIImageView = {
        let arrowImgView = UIImageView(image: UIImage(named: "mine_arrow_right"))
        return arrowImgView
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateItem(item : PersonalModuleItem) {
        if let icon = item.icon, !icon.isEmpty {
            iconImgView.image = UIImage(named:icon)
        } else {
            iconImgView.image = nil
        }
        titleLabel.text = item.title;
        redPointView.isHidden = !item.isShowRedPoint
    }

    func setupUI() {
        
        self.backgroundColor = .clear
        self.selectionStyle = .none
        
        contentView.addSubview(iconImgView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(arrowImgView)
        contentView.addSubview(redPointView)
        
        iconImgView.snp.makeConstraints { make in
            make.left.equalTo(contentView.snp.left).offset(27)
            make.centerY.equalTo(contentView)
            make.width.height.equalTo(23)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(contentView)
            make.left.equalTo(iconImgView.snp.right).offset(10)
            make.right.equalTo(redPointView.snp.left).offset(-5)
        }
        
        redPointView.snp.makeConstraints { make in
            make.width.height.equalTo(Self.redPointWidth)
            make.centerY.equalToSuperview()
            make.right.equalTo(arrowImgView.snp.left).offset(-5)
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.width.equalTo(20)
            make.height.equalTo(20)
            make.centerY.equalTo(contentView)
            make.right.equalTo(contentView).offset(-27)
        }
    }

}
