//
//  YHUserInfoHeaderView.swift
//  galaxy
//
//  Created by edy on 2024/2/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHUserInfoHeaderView: UIView {
    
    static let likeTag = 9527
    static let collectTag = 9528
    static let scanTag = 9529

    var settingBlock:(()->Void)?
    var evaluateBlock:(()->Void)?
    var avatarClickBlock:(()->Void)?
    var nickNameClickBlock:(()->Void)?
    var likeClick:(()->Void)?
    var collectClick:(()->Void)?
    var recentScanClick:(()->Void)?
    
    var nickName:String? {
        didSet {
            userNameLabel.text = nickName
        }
    }
    var isShowSettingRedPoint:Bool = false {
        didSet {
            self.settingRedPointView.isHidden = !isShowSettingRedPoint
        }
    }

    private lazy var avarImgView:UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "mine_head_default"))
        imgView.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer(target: self, action: #selector(didAvarImgViewTapped))
        imgView.addGestureRecognizer(tap)
        return imgView
    }()
    
    private lazy var userNameLabel:UILabel = {
        let label = UILabel()
        label.text = "登录/注册".local
        label.textColor = UIColor(hexString:"##242424")
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_B(ofSize: 21)
        label.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer(target: self, action: #selector(didNickNameTapped))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var likeLabel:UILabel = {
        let label = UILabel()
        label.text = "点赞 0".local
        label.textColor = UIColor(hex: 0x949DB5)
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.likeTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var collectLabel:UILabel = {
        let label = UILabel()
        label.text = "收藏 0".local
        label.textColor = UIColor(hex: 0x949DB5)
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.collectTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var scanLabel:UILabel = {
        let label = UILabel()
        label.text = "最近浏览 0".local
        label.textColor = UIColor(hex: 0x949DB5)
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.scanTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var line1View:UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex:0x92959D, alpha: 0.2)
        return line
    }()
    
    private lazy var line2View:UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex:0x92959D, alpha: 0.2)
        return line
    }()
    
    
    @objc func tap(gestureRecognizer:UITapGestureRecognizer) {
        if let view = gestureRecognizer.view {
            if view.tag == Self.likeTag {
                self.likeClick?()
                
            } else if view.tag == Self.collectTag {
                self.collectClick?()
            
            } else if view.tag == Self.scanTag {
                self.recentScanClick?()
            }
        }
    }
    
    private lazy var evaluateView:UIView = {
        let view = UIView()
        return view
    }()
    
    private lazy var evaluateLabel:UILabel = {
        let label = UILabel()
        label.text = "香港身份20秒极速测评".local
        label.textColor = UIColor(hexString:"#242424")
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    private lazy var evaluateBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("免费测评", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor(hexString:"#242424")
        btn.layer.cornerRadius = kCornerRadius3
        btn.clipsToBounds = true
        btn.addTarget(self, action: #selector(didClickEvaluateBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var evaluateBgImgView:UIImageView = {
        // radio:750:623
        let img = UIImageView(image: UIImage(named: "mine_evaluate_bg"))
        return img
    }()
    
    private lazy var settingBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "mine_btn_setting"), for: .normal)
        btn.addTarget(self, action: #selector(didClickSettingBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var settingRedPointView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = kCornerRadius3
        view.backgroundColor = .failColor
        view.isHidden = true
        return view
    }()
    
    private lazy var settingView:UIView = {
        let view = UIView()
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.clipsToBounds = true
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    static func createView() -> YHUserInfoHeaderView {
       let view = YHUserInfoHeaderView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height:310+k_Height_StatusBar-98))
       return view
    }
    
    func updateLikeCollectCount(_ model: YHCollectionModel) {
    
        let likeCount = showCount(model.myLikeCount)
        let collectCount = showCount(model.myCollectCount)
        let scanCount = showCount(model.myViewCount)
        
        self.likeLabel.text = "点赞 \(likeCount)"
        self.collectLabel.text = "收藏 \(collectCount)"
        self.scanLabel.text = "最近浏览 \(scanCount)"
    }
    
    func showCount(_ count: Int)-> String {        
        return count < 10000 ? String(count) : String(format: "%.1fw", Double(count/1000)/10.0)
    }
    
    private func createUI() {
    
        self.addSubview(settingView)
        settingView.addSubview(settingBtn)
        settingView.addSubview(settingRedPointView)
        
        self.addSubview(avarImgView)
        self.addSubview(userNameLabel)
        
        self.addSubview(likeLabel)
        self.addSubview(collectLabel)
        self.addSubview(scanLabel)
        self.addSubview(line1View)
        self.addSubview(line2View)

//        self.addSubview(evaluateView)
        evaluateView.addSubview(evaluateBgImgView)
        evaluateView.addSubview(evaluateLabel)
        evaluateView.addSubview(evaluateBtn)
        
        settingView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_statusBar())
            make.height.equalTo(44.0)
        }
        
        settingBtn.snp.makeConstraints { make in
            make.width.height.equalTo(21.0)
            make.right.equalToSuperview().offset(-21)
            make.centerY.equalToSuperview()
        }
        
        settingRedPointView.snp.makeConstraints { make in
            make.width.height.equalTo(6)
            make.left.equalTo(settingBtn.snp.right).offset(-3)
            make.bottom.equalTo(settingBtn.snp.top).offset(3)
        }

        avarImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 72, height: 72))
            make.top.equalTo(settingBtn.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(30)
        }
        
        userNameLabel.snp.makeConstraints { make in
            make.left.equalTo(avarImgView)
            make.top.equalTo(avarImgView.snp.bottom).offset(16)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(25.0)
        }
        
        likeLabel.snp.makeConstraints { make in
            make.left.equalTo(avarImgView)
            make.right.equalTo(line1View.snp.left).offset(-12)
            make.height.equalTo(15.0)
            make.top.equalTo(userNameLabel.snp.bottom).offset(10)
        }
        likeLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        likeLabel.setContentHuggingPriority(.required, for: .horizontal)
        
        line1View.snp.makeConstraints { make in
            make.centerY.equalTo(likeLabel)
            make.size.equalTo(CGSize(width: 1, height: 12))
        }
        
        collectLabel.snp.makeConstraints { make in
            make.left.equalTo(line1View.snp.right).offset(12)
            make.right.equalTo(line2View.snp.left).offset(-12)
            make.height.equalTo(15.0)
            make.top.equalTo(likeLabel)
        }
        collectLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        collectLabel.setContentHuggingPriority(.required, for: .horizontal)
        
        line2View.snp.makeConstraints { make in
            make.centerY.equalTo(likeLabel)
            make.size.equalTo(CGSize(width: 1, height: 12))
        }
        
        scanLabel.snp.makeConstraints { make in
            make.left.equalTo(line2View.snp.right).offset(12)
            make.right.equalToSuperview().offset(-31)
            make.height.equalTo(15.0)
            make.top.equalTo(likeLabel)
        }
        scanLabel.setContentCompressionResistancePriority(.required, for: .horizontal)

//        evaluateView.snp.makeConstraints { make in
//            make.left.equalToSuperview().offset(10)
//            make.right.equalToSuperview().offset(-7)
//            make.height.equalTo(98)
//            make.top.equalTo(likeLabel.snp.bottom).offset(17.0)
//        }
        
        evaluateBgImgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        evaluateLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(32)
            make.top.equalToSuperview().offset(33)
            make.height.equalTo(20.0)
        }
        
        evaluateBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-35)
            make.centerY.equalTo(evaluateLabel)
            make.size.equalTo(CGSize(width: 72, height: 32))
        }
    }
    
    @objc func didClickEvaluateBtn(btn: UIButton) {
        
        if let evaluateBlock = evaluateBlock {
            evaluateBlock()
        }
    }
    
    @objc func didClickSettingBtn(btn: UIButton) {
        
        if let settingBlock = settingBlock {
            settingBlock()
        }
    }
    
    @objc func didAvarImgViewTapped() {
        if let avatarClickBlock = avatarClickBlock {
            avatarClickBlock()
        }
    }
    
    @objc func didNickNameTapped() {
        if let nickNameClickBlock = nickNameClickBlock {
            nickNameClickBlock()
        }
    }
}
