//
//  YHMyLikeViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyLikeViewModel: YHBaseViewModel {
    var arrHomeNewsData: [YHHomeListModel]?
    var likeCollectCountInfo: YHCollectionModel =  YHCollectionModel()
    private var curPageIndex : Int = 1
    private var page_Size : Int = 10
    private var totalCount : Int = 0
    var hasMoreForHomeNews : Bool = true
}

extension YHMyLikeViewModel {
    // 1点赞 2收藏
    func getList(_ firstPageFlag : Bool, _ type: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        var params: [String : Any] = ["page": curPageIndex,
                                      "page_size": page_Size,
                                      "operate_type": type]
        if firstPageFlag {
            curPageIndex = 1
            params = ["page": curPageIndex,
                      "page_size": page_Size,
                      "operate_type": type]
        } else {
            params = ["page": curPageIndex + 1,
                      "page_size": page_Size,
                      "operate_type": type]
        }
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.user
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = YHHomeListTotalModel.deserialize(from: dic as? Dictionary) else {
                    self.arrHomeNewsData = []
                    callBackBlock(false,nil)
                    return
                }
                
                for item in result.data {
                    item.calHeightParam()
                }
                
                if firstPageFlag {
                    self.totalCount = result.total
                    self.arrHomeNewsData = result.data
                } else {
                    self.arrHomeNewsData?.append(contentsOf: result.data)
                    curPageIndex = curPageIndex + 1
                }
                
                if let count = self.arrHomeNewsData?.count {
                    if count >= self.totalCount {
                        self.hasMoreForHomeNews = false
                    } else {
                        self.hasMoreForHomeNews = true
                    }
                }
                
                callBackBlock(true, nil)
            } else {
                self.arrHomeNewsData = []
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //最近浏览
    func getList(_ firstPageFlag : Bool, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        var params: [String : Any] = ["page": curPageIndex,
                                      "page_size": page_Size]
        if firstPageFlag {
            curPageIndex = 1
            params = ["page": curPageIndex,
                      "page_size": page_Size]
        } else {
            params = ["page": curPageIndex + 1,
                      "page_size": page_Size]
        }
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.userLook
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = YHHomeListTotalModel.deserialize(from: dic as? Dictionary) else {
                    self.arrHomeNewsData = []
                    callBackBlock(false,nil)
                    return
                }
                
                for item in result.data {
                    item.calHeightParam()
                }
                
                if firstPageFlag {
                    self.totalCount = result.total
                    self.arrHomeNewsData = result.data
                } else {
                    self.arrHomeNewsData?.append(contentsOf: result.data)
                    curPageIndex = curPageIndex + 1
                }
                
                if let count = self.arrHomeNewsData?.count {
                    if count >= self.totalCount {
                        self.hasMoreForHomeNews = false
                    } else {
                        self.hasMoreForHomeNews = true
                    }
                }
                
                callBackBlock(true, nil)
            } else {
                self.arrHomeNewsData = []
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    // 获取点赞、收藏、最近浏览数量
    func getLikeCollectionRecentScanCountInfo(callBack:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.likeCollect
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = YHCollectionModel.deserialize(dict: dic as? Dictionary ) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBack?(false, error)
                    return
                }
                self.likeCollectCountInfo = result as YHCollectionModel
                callBack?(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBack?(false, error)
            }
        } failBlock: { err in
            callBack?(false,err)
        }
    }
}
    

