//
//  YHAnalytics.swift
//  galaxy
//
//  Created by EDY on 2024/1/15.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit
import SensorsAnalyticsSDK

class YHAnalytics {
    
    // 分析初始化
    static func analyticsStart(launchOptions: [UIApplication.LaunchOptionsKey: Any]?) {
        let options = SAConfigOptions.init(serverURL: "url地址，由管理员提供", launchOptions: launchOptions)
        //开启全埋点
        options.autoTrackEventType = [.eventTypeAppStart, .eventTypeAppEnd, .eventTypeAppClick, .eventTypeAppViewScreen]
#if DEBUG
        //开启log
        options.enableLog = true
#endif
         /**
         * 其他配置，如开启可视化全埋点
         */
        //初始化SDK
        SensorsAnalyticsSDK.start(configOptions: options)
    }
    
    //处理数据的Url
    static func handleSchemeUrl(_ url: URL) -> Bool? {
        return SensorsAnalyticsSDK.sharedInstance()?.handleSchemeUrl(url)
    }
    
    // 立即上报
    static func flush() {
        SensorsAnalyticsSDK.sharedInstance()?.flush()
    }
}

// 统计事件，统计时长
extension YHAnalytics {
    // 统计事件名
    static func track(_ event: String, properties: [AnyHashable : Any]? = [:]) {
        SensorsAnalyticsSDK.sharedInstance()?.track(event, withProperties: properties)
    }
    
    // 统计时长 开始
    static func timeStrat(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerStart(event)
    }
    
    // 统计时长 暂停
    static func timePause(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerPause(event)
    }
    
    // 统计时长 继续
    static func timeResume(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerResume(event)
    }
    
    // 统计时长 结束
    static func timeEnd(_ event: String, properties: [AnyHashable : Any]? = [:]) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerEnd(event, withProperties: properties)
    }
}
