//
//  YHVideoPlayerControlView.swift
//  galaxy
//
//  Created by edy on 2024/5/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import BMPlayer
import AVFoundation

class YHVideoPlayerControlView: BMPlayerControlView {

    var isSilient = true {
        didSet {
            self.player?.avPlayer?.isMuted = isSilient
            let imgName = isSilient ? "video_volume_disable" : "video_volume_enable"
            self.volumeBtn.setImage(UIImage(named: imgName), for: .normal)
        }
    }
    
    lazy var volumeBtn = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "video_volume_disable"), for: .normal)
        btn.addTarget(self, action: #selector(didVolumeBtnClicked), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 30, bottom: 20, right: 20)
        return btn
    }()
    
    func createUI() {
        
        self.isFullscreen = false
        self.fullscreenButton.isHidden = true
        self.fullscreenButton.snp.updateConstraints { make in
            make.width.height.equalTo(0)
        }
        self.mainMaskView.addSubview(volumeBtn)
        volumeBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.top.equalTo(20)
            make.right.equalTo(-16)
        }
    }
    
    // MARK: - Init
    override public init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required public init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        createUI()
    }
    
    override public func controlViewAnimation(isShow: Bool) {
        super.controlViewAnimation(isShow: isShow)
        let alpha: CGFloat = isShow ? 1.0 : 0.0
        UIView.animate(withDuration: 0.3, animations: {[weak self] in
            guard let self = self else { return }
            self.volumeBtn.alpha = alpha
        })
    }
    
    @objc func didVolumeBtnClicked() {
        self.isSilient = !self.isSilient
    }
}
