//
//  YHInvitationWithGiftsFirstTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsFirstTableViewCell: UITableViewCell {
    var centerImageView: UIImageView!
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        self.backgroundColor = UIColor(hex: 0xebf4fe)
        centerImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_first")
            return imageView
        }()
        contentView.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.bottom.equalTo(-8)
            make.left.equalTo(12)
            make.right.equalTo(-12)
            make.top.equalTo(8)
        }
    }

}
