//
//  YHImproveRequireItemView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHImproveItem {
    
    var title: String = ""
    var isSelect: Bool = false
    
    init(title: String, isSelect: Bool) {
        self.title = title
        self.isSelect = isSelect
    }
}

class YHImproveRequireItemView: UIView {
    
    var item: YHComprehensiveEevaluationModel = YHComprehensiveEevaluationModel() {
        didSet {
            let a: ASAttributedString = .init(string: "港府要求：", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let b: ASAttributedString = .init(string: item.standardName, .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            titleLabel.attributed.text = a + b
            isSelect = item.is_select
        }
    }
    
    var isSelect: Bool = false {
        didSet {
            self.backgroundColor = isSelect ? .init(hex: 0xFBF7F3) : .init(hex: 0xF8F9FB)
            self.selectImgV.image = UIImage(named: isSelect ? "my_shceme_improve_select" : "my_shceme_improve_unselect")
            self.layer.borderColor = isSelect ? UIColor.init(hex: 0xD48638).cgColor : nil
            self.layer.borderWidth = isSelect ? 1.0: 0.0
        }
    }

    lazy var selectImgV = {
        let imgV = UIImageView(image: UIImage(named: "my_shceme_improve_unselect"))
        return imgV
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: .zero)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap))
        self.addGestureRecognizer(tap)
        
        self.backgroundColor = .init(hex: 0xF8F9FB)
        self.layer.cornerRadius = 4.0
        self.clipsToBounds = true
        
        self.addSubview(selectImgV)
        self.addSubview(titleLabel)
        
        selectImgV.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.left.equalTo(12)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(12)
            make.bottom.equalTo(-12)
            make.right.equalTo(-12)
            make.left.equalTo(selectImgV.snp.right).offset(12)
        }
    }
    
    @objc func tap() {
        item.is_select = !item.is_select
        isSelect = item.is_select
    }

}
