//
//  YHEducationInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/2/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEducationInfoCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHEducationInfoCell"
    let horizonalGap = 18.0
    var deleteBlock: (() -> Void)?
    var isShowDeleteBtn: Bool = false {
        didSet {
            deleteButton.isHidden = !isShowDeleteBtn
            timeLabel.isHidden = isShowDeleteBtn
            arrowImgView.isHidden = isShowDeleteBtn
        }
    }
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_B(ofSize: 14)
        return label
    }()
    
    lazy var subTitleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .labelTextColor2
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var timeLabel: UILabel = {
        let label = UILabel()
        label.textColor = .labelTextColor2
        label.textAlignment = .right
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    private lazy var deleteButton: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("删除".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.failColor, for: .normal)
        btn.addTarget(self, action: #selector(didClickDeleteBtn(btn:)), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    private lazy var arrowImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imgView
    }()
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    // 是否隐藏顶部分割线
    var isHiddenTopLine: Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    @objc func didClickDeleteBtn(btn: UIButton) {
        
        if let deleteBlock = deleteBlock {
            deleteBlock()
        }
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(subTitleLabel)
        contentView.addSubview(timeLabel)
        contentView.addSubview(arrowImgView)
        contentView.addSubview(deleteButton)
        contentView.addSubview(topLine)
        
        titleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalTo(timeLabel.snp.left).offset(-8)
            make.top.equalToSuperview().offset(16)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.width.equalTo(115)
            make.height.equalTo(20)
            make.right.equalTo(arrowImgView.snp.left)
            make.top.equalTo(titleLabel)
        }
        
        deleteButton.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 64, height: 40))
            make.centerY.equalTo(timeLabel)
            make.right.equalToSuperview()
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.width.height.equalTo(20.0)
            make.centerY.equalTo(timeLabel)
            make.right.equalToSuperview().offset(-horizonalGap)
        }
        
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.bottom.equalToSuperview().offset(-16)
            make.right.equalToSuperview().offset(-horizonalGap)
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
    }
}
