//
//  YHWorkExperienceCompanyViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/11/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExperienceCompanyViewModel: YHBaseViewModel {
    var model: YHWorkExperienceCompanyModel = YHWorkExperienceCompanyModel()
    
    func requestWorkQuestionDetail(_ workId: Int, _ orderId: Int, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let param: [String: Any] = ["work_id": workId, "order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.workQuestionDetail
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {

                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkExperienceCompanyModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.model = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func saveWorkQuestion(model: YHWorkExperienceCompanyModel, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": model.order_id,
                                      "work_id": model.work_id,
                                      "is_ipo_company": model.is_ipo_company,
                                      "has_company_equity": model.has_company_equity,
                                      "has_sales_reached": model.has_sales_reached,
                                      "has_ipo_company_equity": model.has_ipo_company_equity,
                                      "has_ipo_sales_reached": model.has_ipo_sales_reached,
                                      "company_location": model.company_location,
                                      "has_provide_certificate": model.has_provide_certificate]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveWorkQuestion
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkExperiencePositionModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

}
