//
//  YHGCWorkExperienceModel.swift
//  galaxy
//
//  Created by EDY on 2024/12/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHGCWorkExperienceModel: SmartCodable {
    var id: Int = 0
    var order_id: Int = 0
    var company_name: String = ""
    var entry_time: String = ""
    var departure_time: String = ""
    var location_aboard: Int = 0
    var position: String = ""
    var has_work_certificate: Int = 0
    var company_type: String = ""
    var company_type_other: String = ""
    var location: YHAddress = YHAddress()
    
    /// 公司近一年的营业额 对于高A，仅当收入类型包含 6/7/8/10 时，该字段才有效
    var turnover: String = "0"
    /// 高A使用 收入类型 1 工资薪金所得及全年一次性奖金; 2 上市公司股票期权或股权收入; 3 持股公司分红收入; 4 个体工商户/合伙企业/独资企业经营所得收入; 5
    /// 股权转让收入; 6 内地公司收入(持股50%及以上); 7 香港公司收入(持股50%及以上); 8 其他境外公司收入(持股50%及以上); 10 澳门公司收入(持股50%及以上)
    var type_of_income: [Int] = []
    /// 高A使用 收入金额
    var income: String = "0"
    
    required init() {
    }
}

/*
 
 /// 工作经历-详情-具体数据
 // MARK: - InfoflowWorkDetailData
 struct InfoflowWorkDetailData {
     /// 行政架构级别
     var administrativeLevel: Int?
     /// 公司业务性质/范畴/所属行业
     var businessNature: String?
     /// 工作经验备注
     var businessRemark: String?
     /// 用人单位介绍
     var companyIntroduce: String?
     /// 高管在企业管理人数规模
     var companyManageTotal: String?
     /// 企业人数规模
     var companyMemberTotal: String?
     /// 公司名称
     var companyName: String?
     /// 高才使用 职业界别
     var companyType: String?
     /// 高才使用 其他职业界别
     var companyTypeOther: String?
     /// 用人单位官网
     var companyWebsite: String?
     /// 创建来源(rpc.rpc_app.id)
     var createFromAppid: Int?
     /// 创建时间
     var createdAt: String?
     /// 用户中心对应模块的id
     var customerCenterid: Int?
     /// 删除时间
     var deletedAt: String?
     /// 离职时间
     var departureTime: String?
     /// 职责性质
     var duty: String?
     /// 入职时间
     var entryTime: String?
     /// 高管证明文件
     var executivesCertificate: String?
     /// 简历/工作总结附件
     var file: [InfoflowWorkDetaiFile]?
     /// 高才使用 是否能提供工作证明 0 未知 1 是 2 否
     var hasWorkCertificate: Int?
     /// 工作亮点
     var highlights: String?
     /// 工作经历id 只在返回工作经历详情时才必需，保存工作经历时非必需
     var id: Int?
     /// 高A使用 收入金额
     var income: String?
     /// 雇主所属机构性质
     var industry: String?
     /// 国际工作经验0没有1有
     var internationalWorkExperience: Int?
     /// 是否高管？ 1是 2否
     var isExecutives: Int?
     /// 是否名企 0.否  1.是
     var isFamousEnterprise: Int?
     /// 是否项目详细介绍
     var isProjectIntroduction: Int?
     /// 是否展示 1是0否 保存工作经历时非必需，不传则默认1
     var isShow: Int?
     /// 是否合成 1合成 2不合成
     var isSynthetic: Int?
     var location: InfoflowWorkDetaiLocation?
     /// 工作地点  0-国内 1-国外 2-未知
     var locationAboard: Int?
     /// 是否重要项目负责人 0-未知；1-是；2-否
     var masterOfImportantProject: Int?
     /// 是否符合清单 1-是；0-否
     var matchListing: Int?
     /// 是否不需要上传简历/工作总结附件
     var notNeedUploadFile: Int?
     /// 老CRM的order_child表id
     var oldid: Int?
     /// 操作人英文
     var operatorEnglishName: String?
     /// 操作人ID
     var operatorid: Int?
     /// 操作人中文
     var operatorName: String?
     /// 订单id
     var orderid: Int?
     /// 职位
     var position: String?
     /// 职位水平(1.高级经理人2.中级经理人3.初级经理人4.专业人士5.半专业人士6.其他)
     var professionalLevel: Int?
     /// 职业水平其他
     var professionalOther: String?
     /// 工作经历项目
     var projects: [InfoflowWorkDetaiProject]?
     /// 备注
     var remark: String?
     /// 工作信息填写进度：0:基本信息 1:工作职责 2:工作亮点 3:简历/总结
     var step: Int?
     /// 高管任职结束时间
     var topManagerEndAt: String?
     /// 高管任职开始时间
     var topManagerStartAt: String?
     /// 公司近一年的营业额 对于高A，仅当收入类型包含 6/7/8/10 时，该字段才有效
     var turnover: String?
     /// 高A使用 收入类型 1 工资薪金所得及全年一次性奖金; 2 上市公司股票期权或股权收入; 3 持股公司分红收入; 4 个体工商户/合伙企业/独资企业经营所得收入; 5
     /// 股权转让收入; 6 内地公司收入(持股50%及以上); 7 香港公司收入(持股50%及以上); 8 其他境外公司收入(持股50%及以上); 10 澳门公司收入(持股50%及以上)
     var typeOfIncome: [Int]?
     /// 更新来源(rpc.rpc_app.id)
     var updateFromAppid: Int?
     /// 更新时间
     var updatedAt: String?
     /// 是否校验数据准确性 0-不检验；1-校验  （只在保存工作经历时才必需，返回工作经历详情数据时非必需）
     var verify: Int?
     /// 工作职责
     var wduty: String?
     /// 工作证明文件
     var workCertificate: String?
 }

 /// 工作经历-详情-简历/工作总结附件
 // MARK: - InfoflowWorkDetaiFile
 struct InfoflowWorkDetaiFile {
     /// 文件名
     var fileName: String?
     /// 文件地址
     var fileUrl: String?
     /// 上传时间
     var uploadedAt: String?
 }

 /// 工作经历-详情-位置信息
 // MARK: - InfoflowWorkDetaiLocation
 struct InfoflowWorkDetaiLocation {
     /// 省市
     var area: [String]?
     /// 国家
     var country: String?
     /// 详细
     var details: String?
     /// 国外具体地址
     var foreign: String?
 }

 /// 工作经历-详情-项目信息
 // MARK: - InfoflowWorkDetaiProject
 struct InfoflowWorkDetaiProject {
     /// 来源
     var createFromAppid: Int?
     /// 创建时间
     var createdAt: String?
     /// 用户中心对应模块的id
     var customerCenterid: Int?
     /// 删除时间
     var deletedAt: String?
     /// 项目ID
     var id: Int?
     /// 订单id
     var orderid: Int?
     /// 工作项目结束时间
     var projectEndTime: String?
     /// 工作项目亮点
     var projectHighlights: String?
     /// 项目名称
     var projectName: String?
     /// 工作项目开始时间
     var projectStartTime: String?
     /// 更新来源
     var updateFromAppid: Int?
     /// 更新时间
     var updatedAt: String?
     /// 工作经验ID
     var workid: Int?
 }

 */
