//
//  YHPlanItemView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanItemView: UIView {

    lazy var iconImgV: UIImageView = {
        let v = UIImageView()
        v.image = UIImage(named: "plan_item_icon")
        v.contentMode = .scaleAspectFit
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .mainTextColor
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 12)
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        backgroundColor = .clear
        self.addSubview(iconImgV)
        self.addSubview(titleLabel)

        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(12)
            make.left.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgV.snp.right).offset(4)
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(17)
        }
        
    }
}

class YHPlanItemsView: UIView {
    
    lazy var item1View: YHPlanItemView = {
        let v = YHPlanItemView()
        v.titleLabel.text = "私人定制"
        return v
    }()
    
    lazy var item2View: YHPlanItemView = {
        let v = YHPlanItemView()
        v.titleLabel.text = "官方计划"
        return v
    }()
    
    lazy var item3View: YHPlanItemView = {
        let v = YHPlanItemView()
        v.titleLabel.text = "模块化配置"
        return v
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        backgroundColor = .clear
        self.addSubview(item1View)
        self.addSubview(item2View)
        self.addSubview(item3View)
        
        item1View.snp.makeConstraints { make in
            make.right.equalTo(item2View.snp.left).offset(-24)
            make.height.equalTo(17)
            make.centerY.equalToSuperview()
        }
        
        item3View.snp.makeConstraints { make in
            make.left.equalTo(item2View.snp.right).offset(24)
            make.height.equalTo(17)
            make.centerY.equalToSuperview()
        }
        
        item2View.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(17)
        }
    }
}
