//
//  YHStepView.swift
//  galaxy
//
//  Created by EDY on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHStepView: UIScrollView {
    
    static let height = 104.0
    var viewWidth = KScreenWidth
    typealias Block = (Int) -> Void
    var block: Block?
    var dataSource: [String]? {
        didSet {
            setUpView(dataSource ?? [])
        }
    }
    var currentIndex: Int = 0 {
        didSet {
            updateView(dataSource ?? [])
        }
    }
    var maxIndex: Int = 0
    var stepSpace: CGFloat = 6
    var lineWidth: CGFloat {
        guard let dataSource = dataSource else { return 0 }
        let lineCount = dataSource.count - 1
        if dataSource.count <= 2 {
            let contentWidth = 89 * 2 + Int(stepSpace) * 2 * lineCount + 14 * dataSource.count
            let width = (viewWidth - CGFloat(contentWidth)) / lineCount.cgFloat
            return width
        } else if dataSource.count <= 4 {
            let contentWidth = 43 * 2 + Int(stepSpace) * 2 * lineCount + 14 * dataSource.count
            let width = (viewWidth - CGFloat(contentWidth)) / lineCount.cgFloat
            return width
        } else {
            let contentWidth = 43 * 2 + Int(stepSpace) * 2 * 3 + 14 * 4
            let width = (viewWidth - CGFloat(contentWidth)) / lineCount.cgFloat
            return width
        }
    }
    
    var spaceWidth: CGFloat {
        guard let dataSource = dataSource else { return 0 }
        if dataSource.count <= 2 {
            return 89
        } else if dataSource.count <= 4 {
            return 43
        } else {
            return 43
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView(_ array: [String]) {
        self.removeSubviews()
        for i in 0 ..< array.count {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "mid_image2"), for: .normal)
            button.tag = 1000 + i
            button.addTarget(self, action: #selector(buttonClick(_:)), for: .touchUpInside)
            addSubview(button)
            printLog("\(lineWidth)")
            button.snp.makeConstraints { make in
                make.top.equalTo(28)
                make.left.equalTo(spaceWidth + i.cgFloat * (lineWidth + stepSpace * 2) + 14 * i.cgFloat)
                make.width.height.equalTo(14)
            }
            button.YH_clickEdgeInsets = UIEdgeInsets(top: 50, left: 50, bottom: 50, right: 50)
            let label = UILabel()
            label.text = array[i]
            label.font = UIFont.PFSC_R(ofSize: 13)
            label.textAlignment = .center
            label.tag = 2000 + i
            label.textColor = UIColor.mainTextColor
            addSubview(label)
            label.snp.makeConstraints { make in
                make.centerX.equalTo(button.snp.centerX)
                make.top.equalTo(button.snp.bottom).offset(14)
                make.height.equalTo(20)
            }
            
            if i < array.count - 1 {
                let line = UIImageView()
                line.image = UIImage(named: "service_progress_success")
                line.tag = 3000 + i
                addSubview(line)
                line.snp.makeConstraints { make in
                    make.centerY.equalTo(button.snp.centerY)
                    make.left.equalTo(button.snp.right).offset(stepSpace)
                    make.height.equalTo(3)
                    make.width.equalTo(lineWidth)
                }
                if i < currentIndex {
                    line.image = UIImage(named: "service_progress_success")
                } else {
                    line.image = UIImage(named: "service_progress_fail")
                }
            }
            
            if currentIndex == i {
                button.setBackgroundImage(UIImage(named: "mid_image1"), for: .normal)
                label.textColor = UIColor.brandMainColor
            } else if i < currentIndex {
                button.setBackgroundImage(UIImage(named: "mid_image"), for: .normal)
                label.textColor = UIColor.mainTextColor
            } else {
                button.setBackgroundImage(UIImage(named: "mid_image2"), for: .normal)
                label.textColor = UIColor.placeHolderColor
            }
        }
    }
    
    func updateView(_ array: [String]) {
        for i in 0 ..< array.count {
            let button = viewWithTag(1000 + i) as? UIButton
            let lable = viewWithTag(2000 + i) as? UILabel
            if i < array.count - 1 {
                let line = viewWithTag(3000 + i) as? UIImageView
                if i < currentIndex {
                    line?.image = UIImage(named: "service_progress_success")
                } else {
                    line?.image = UIImage(named: "service_progress_fail")
                }
            }
            if currentIndex == i {
                button?.setBackgroundImage(UIImage(named: "mid_image1"), for: .normal)
                lable?.textColor = UIColor.brandMainColor
                lable?.font = UIFont.PFSC_M(ofSize: 13)
            } else if i < currentIndex {
                button?.setBackgroundImage(UIImage(named: "mid_image"), for: .normal)
                lable?.textColor = UIColor.mainTextColor
                lable?.font = UIFont.PFSC_R(ofSize: 13)
            } else {
                button?.setBackgroundImage(UIImage(named: "mid_image2"), for: .normal)
                lable?.textColor = UIColor.placeHolderColor
                lable?.font = UIFont.PFSC_R(ofSize: 13)
            }
        }
    }
    
    @objc func buttonClick(_ button: UIButton) {
        let tag = button.tag
        if tag - 1000 <= maxIndex {
            if let block = block {
                currentIndex = tag - 1000
                block(currentIndex)
            }
        }
    }
}
