//
//  YHResignAppointTimeSettingModel.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHResignAppointTimeSettingModel: SmartCodable {

    var ready_to_submit_at: String = ""  // 预约在港递交时间
    var leave_hk_at: String = ""   // 预计离港时间
    var notleaveHK: Bool = false // 暂不离港
    var users: [YHResignAppointMember] = []
    var isShowUsers: Bool = false // 是否展示选择用户列表
    var itemIndex: Int = 0 // 第几批 从0开始
    var isClickSubmit: Bool = false
    var isHaveAppointed: Bool = false
    
    var server_submit_deadLine_start: String = ""
    var server_submit_deadLine_end: String = ""
    
    func getLeaveHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if leave_hk_at.count <= format.count {
            return leave_hk_at
        }
        return String(leave_hk_at.prefix(format.count))
    }
    
    func getSubmitHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if ready_to_submit_at.count <= format.count {
            return ready_to_submit_at
        }
        return String(ready_to_submit_at.prefix(format.count))
    }
    
    required init() {
        
    }
    
    func checkSubmitTime() -> Bool {
        
        if server_submit_deadLine_start.isEmpty || server_submit_deadLine_end.isEmpty {
            return true
        }
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        guard let startDate = dateFormatter.date(from: server_submit_deadLine_start) else {
            return true
        }
        guard let endDate = dateFormatter.date(from: server_submit_deadLine_end) else {
            return true
        }
        
        // 将结束日期C设置为当天的23:59:59，确保包含整天
        let calendar = Calendar.current
        guard let endOfDay = calendar.date(bySettingHour: 23, minute: 59, second: 59, of: endDate) else {
            return true
        }
        
        let dateTimeFormatter = DateFormatter()
        if self.ready_to_submit_at.count == "yyyy-MM-dd HH:mm:ss".count {
            dateTimeFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
            
        } else if self.ready_to_submit_at.count == "yyyy-MM-dd HH:mm".count {
            dateTimeFormatter.dateFormat = "yyyy-MM-dd HH:mm"
        } else {
            dateTimeFormatter.dateFormat = "yyyy-MM-dd"
        }
        guard let targetDate = dateTimeFormatter.date(from: self.ready_to_submit_at) else {
            return true
        }
        
        // 判断目标日期是否在范围内 (包含边界)
        let result = (startDate <= targetDate && targetDate <= endOfDay)
        return result
    }
    
}
