//
//  YHGCDocumentPromptTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHGCDocumentPromptTableViewCell: UITableViewCell {

    var centerView: UIImageView!
    var promptImageView: UIImageView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var link: String = ""
    var type: YHMySignatureDetailModel? {
        didSet {
            updatePrompt()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIImageView()
            view.image = UIImage(named: "document_prompt_bg")
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            view.isUserInteractionEnabled = true
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        promptImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "tips_icon")
            return view
        }()
        centerView.addSubview(promptImageView)
        promptImageView.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.left.equalTo(16)
            make.top.equalTo(16)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 12)
            label.textColor = UIColor.brandMainColor
            label.text = "填写指引"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.top.equalTo(16)
            make.height.equalTo(17)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.labelTextColor2
            label.numberOfLines = 0
            let a: ASAttributedString = .init("请如实填写，以下补充信息将使用于生成赴港同意书\n单位名称", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
            let aa: ASAttributedString = .init("需要与盖章单位名称一致", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
            label.attributed.text = a + aa
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(15)
            make.right.equalTo(-15)
            make.top.equalTo(38.5)
        }
        
    }
    
    func updatePrompt() {
        // 1000-代理委托书，1001-同意书，1002-声明书
        guard let dataSource = type else { return }
        let type = dataSource.docType // 1000-代理委托书; 1001-赴港同意书; 1002-声明书
        let state = dataSource.docStatus // 1003-待签署; 1004-已签署; 1005-待审核; 1006-已驳回; 1007-已完成
        if type == 1000 {
            if state == 1000 || state == 1001 || state == 1002 || state == 1003 {
                let a: ASAttributedString = .init("请主申请人", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                let aa: ASAttributedString = .init("点击签署或上传已签署文件", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
                subTitleLabel.attributed.text = a + aa
            } else if state == 1004 || state == 1005 || state == 1006 {
                let a: ASAttributedString = .init("审核中，请您耐心等待~", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            } else {
                let a: ASAttributedString = .init("您已完成签署，预祝您早日获批！", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            }
        } else if type == 1001 {
            if state == 1000 || state == 1001 || state == 1002 {
                let a: ASAttributedString = .init("请主申请人", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                let aa: ASAttributedString = .init("补充", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("信息以便进行后续签章", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a + aa + aaa
            } else if state == 1003 {
                let a: ASAttributedString = .init("请主申请人", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                let aa: ASAttributedString = .init("上传已签章文件", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
                subTitleLabel.attributed.text = a + aa
            } else if state == 1004 || state == 1005 || state == 1006 {
                let a: ASAttributedString = .init("审核中，请您耐心等待~", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            } else {
                let a: ASAttributedString = .init("您已完成签章，预祝您早日获批！", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            }
        } else {
            if state == 1000 || state == 1001 || state == 1002 || state == 1003 {
                let a: ASAttributedString = .init("请您尽快核对文本内容，如内容无误，请主申请人", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                let aa: ASAttributedString = .init("点击签署或上传已签署文件", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
                subTitleLabel.attributed.text = a + aa
            } else if state == 1004 || state == 1005 || state == 1006 {
                let a: ASAttributedString = .init("审核中，请您耐心等待~", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            } else {
                let a: ASAttributedString = .init("您已完成签署，预祝您早日获批！", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.subTextColor2))
                subTitleLabel.attributed.text = a
            }
            
        }
    }
}
