//
//  YHDetailViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDetailViewController: YHBaseViewController {
    
    var tableView: UITableView!
    var viewModel: YHListViewModel = YHListViewModel()
    var model = YHHKEventModel()
    
    lazy var headView: YHHeadView = {
        let headView = YHHeadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 581))
        return headView
    }()
    
    lazy var navBar: YHCustomNavigationBar = {
        let bar = YHCustomNavigationBar.navBar()
        bar.backgroundColor = .clear
        bar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
        bar.backBlock = {
            [weak self] in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
        return bar
    }()
    
    lazy var navView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        view.addSubview(self.navBar)
        self.navBar.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(k_Height_NavContentBar)
        }
        return view
    }()
    
    lazy var visitBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("预约到访", for: .normal)
        btn.addTarget(self, action: #selector(visitBtnClicked), for: .touchUpInside)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandGrayColor8
        btn.layer.cornerRadius = 3.0
        btn.masksToBounds = true
        return btn
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        loadData()
    }
    
    @objc func visitBtnClicked() {
        let name = YHURLEncodeHelper.urlEncodedString(model.tag) ?? ""
        var url = YHBaseUrlManager.shared.businessH5Url() + "/pre-sale/startup/visit/appointment?centerName=" + name
        if YHLoginManager.shared.isLogin() {
            let token = YHLoginManager.shared.h5Token
            let urlHasParam = String.hasQueryParameters(urlString: url)
            if urlHasParam {
                url = url + "&param=" + token
            } else {
                url = url + "?param=" + token
            }
        }
        var tUrl = url
        if !url.contains("navigationH=") {
            tUrl = url + "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            if url.contains("?") {
                tUrl = url + "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            }
        }
        let vc = YHH5WebViewVC()
        vc.url = tUrl
        vc.isFullScreenFlag = false
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
}

extension YHDetailViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (self.viewModel.model.first?.list.count ?? 1) - 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHListTableViewCell.self)
        cell.imageUrl = self.viewModel.model.first?.list[indexPath.row + 1]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 243.fix
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
}

extension YHDetailViewController {
    func setView() {
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.dataSource = self
            tableView.delegate = self
            tableView.tableHeaderView = headView
            tableView.tableFooterView = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 20))
            tableView.register(cellWithClass: YHListTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        view.addSubview(visitBtn)
        view.addSubview(self.navView)

        tableView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.bottom.equalTo(visitBtn.snp.top).offset(-8)
        }
        self.navView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(k_Height_NavigationtBarAndStatuBar)
        }
        
        visitBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(46)
            make.bottom.equalTo(-10-k_Height_safeAreaInsetsBottom())
        }
    }
    
    func loadData() {
        viewModel.getToolsEvent(pid: model.id) {[weak self] _, _ in
            guard let self = self else { return }
            guard let url = URL(string: self.viewModel.model.first?.list.first) else { return }
            self.headView.imageView.kf.setImage(with: url)
            self.tableView.reloadData()
        }
    }
}

extension YHDetailViewController: UIScrollViewDelegate {
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        
        var percent = scrollView.contentOffset.y/k_Height_NavigationtBarAndStatuBar
        if percent < 0.0 {
            percent = 0.0
        } else if percent > 1.0 {
            percent = 1.0
        }
        navView.backgroundColor = UIColor(hex: 0xFFFFFF, alpha: percent)
        
        if percent >= 0.5 {
            navBar.backButton.setImage(UIImage(named: "back_icon"), for: .normal)
            navBar.title = self.model.tag
            
        } else {
            navBar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
            navBar.title = ""
        }
    }
}
