//
//  YHActivitySignSuccessViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivitySignSuccessViewController: YHBaseViewController {
    
    var activityId: String = ""
    let viewModel: YHActivityViewModel = YHActivityViewModel()
    
    private let tableView = UITableView(frame: .zero, style: .grouped)
    private var hasPrize: Bool = false
    private var result: YHSignSuccessActivity?
    
    lazy var backImgV: UIImageView = {
       let v = UIImageView()
       v.image = UIImage(named: "salon_result_bg")
       return v
    }()
    
    lazy var signFailBgView: UIView = {
        let v = UIView()
        let imgV = UIImageView(image: UIImage(named: "salon_fail_icon"))
        v.addSubview(imgV)
        
        let titleLabel = UILabel()
        titleLabel.font = .PFSC_B(ofSize: 18)
        titleLabel.textColor = .brandGrayColor8
        titleLabel.textAlignment = .center
        titleLabel.text = "签到失败"
        v.addSubview(titleLabel)
        
        let detailLabel = UILabel()
        detailLabel.font = .PFSC_R(ofSize: 14)
        detailLabel.textColor = .brandGrayColor6
        detailLabel.textAlignment = .center
        detailLabel.text = "活动已结束或因其他未知原因，详情请咨询现场顾问"
        v.addSubview(detailLabel)
        
        imgV.snp.makeConstraints { make in
            make.width.height.equalTo(128)
            make.top.equalTo(100)
            make.centerX.equalToSuperview()
        }
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
            make.top.equalTo(imgV.snp.bottom)
        }
        detailLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        return v
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        requestData()
    }
    
    private func setupUI() {
        view.backgroundColor =  .contentBkgColor
        view.addSubview(backImgV)
        view.addSubview(signFailBgView)

        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsVerticalScrollIndicator = false
        tableView.register(YHSignPrizeCell.self, forCellReuseIdentifier: YHSignPrizeCell.cellReuseIdentifier)
        tableView.register(YHSignActivityInfoCell.self, forCellReuseIdentifier: YHSignActivityInfoCell.cellReuseIdentifier)
        view.addSubview(tableView)
        
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    
        backImgV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(backImgV.snp.width).multipliedBy(422.0/375.0)
        }
        signFailBgView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    func requestData() {
        self.viewModel.getActivitySign(id: self.activityId) { [weak self] success in
            guard let self = self else {
                return
            }
            self.tableView.isHidden = !success
            self.signFailBgView.isHidden = success
            backImgV.isHidden = !success
            gk_navTitle = success ? "" : "签到结果"
            
            self.result = self.viewModel.signActivityModel
            self.hasPrize = false
            if let _ = self.viewModel.signActivityModel?.gift {
                self.hasPrize = true
            }
            self.tableView.reloadData()
        }
    }
}

// MARK: - UITableViewDelegate & DataSource
extension YHActivitySignSuccessViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if hasPrize {
            return 2 // 标题 + 奖品 + 活动信息
        } else {
            return 1 // 标题 + 活动信息
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if hasPrize {
            if indexPath.row == 0 {
                // 奖品 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignPrizeCell.cellReuseIdentifier, for: indexPath) as? YHSignPrizeCell else {
                    return UITableViewCell()
                }
                if let result = self.result {
                    cell.configure(with: result)
                    cell.onImageHeightChanged = { [weak self] in
                        guard let self = self else { return }
                        UIView.performWithoutAnimation {
                            self.tableView.reloadRows(at: [indexPath], with: .none)
                        }
                    }
                }
                return cell
                
            } else {
                // 活动信息 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                    return UITableViewCell()
                }
                if let result = self.result {
                    cell.configure(with: result)
                }
                return cell
            }
        } else {
            // 无奖品时，第二个就是活动信息 Cell
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                return UITableViewCell()
            }
            if let result = self.result {
                cell.configure(with: result)
            }
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = YHSignSuccessHeaderView()
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 83
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let v = UIView()
        let logoImgV: UIImageView = UIImageView(image: UIImage(named: "salon_logo"))
        v.addSubview(logoImgV)
        logoImgV.snp.makeConstraints { make in
            make.width.equalTo(133)
            make.height.equalTo(26)
            make.centerX.equalToSuperview()
        }
        return v
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 58
    }
}
