//
//  YHActivityTravelCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityTravelCell: UITableViewCell {
    static let cellReuseIdentifier = "YHActivityTravelCell"
    
    private var isApplyFlag: Bool = true
    
    var dataModel: YHActivityTravelModel? {
        didSet {
            updateUI()
        }
    }
        
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    lazy var statusLable: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 28)
        lable.text = "已报名"
        return lable
    }()
    
    // 活动名称地址
    lazy var acitivityTitle: YHActivityTravelitemView = {
        let view = YHActivityTravelitemView()
        return view
    }()
    
    // 报名人数
    lazy var acitivityApplyInfo: YHActivityApplyInfoItemView = {
        let view = YHActivityApplyInfoItemView()
        return view
    }()
    
    // 活动温馨提示
    lazy var acitivityTips: YHActivityTipsItemView = {
        let view = YHActivityTipsItemView()
        view.showLineFlag = false
        return view
    }()
}

extension YHActivityTravelCell {
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        if model.status.int == 2 {
            statusLable.text = "已报名"
            
        } else if model.status.int == 4 || model.status.int == 1 {
            statusLable.text = "已取消"
            
        } else if model.status.int == 3 {
            statusLable.text = "活动结束"
            
        } else if model.status.int == 5 {
            statusLable.text = "已下架"
        } else {
            statusLable.text = ""
        }
        
        acitivityTitle.dataModel = model
        acitivityTitle.snp.remakeConstraints { make in
            make.top.equalTo(statusLable.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
        }
        
        acitivityApplyInfo.dataModel = model.user
        acitivityApplyInfo.snp.remakeConstraints { make in
            make.top.equalTo(acitivityTitle.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
        }
        
        var lastView: UIView = acitivityApplyInfo
        
        if !model.tips.isEmpty {
            acitivityTips.isHidden = false
            acitivityTips.tipsText = model.tips
            acitivityTips.snp.remakeConstraints { make in
                make.top.equalTo(acitivityApplyInfo.snp.bottom).offset(32)
                make.left.right.equalToSuperview()
                make.bottom.equalTo(-32)
            }
            acitivityTips.layoutIfNeeded()
            lastView = acitivityTips
        } else {
            acitivityTips.isHidden = true
        }
    }
    
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        selectionStyle = .none
        
        contentView.addSubview(statusLable)
        contentView.addSubview(acitivityTitle)
        contentView.addSubview(acitivityApplyInfo)
        contentView.addSubview(acitivityTips)
        
        statusLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(40)
        }
        
        acitivityTitle.snp.makeConstraints { make in
            make.top.equalTo(statusLable.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
        }
        
        acitivityApplyInfo.snp.makeConstraints { make in
            make.top.equalTo(acitivityTitle.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
            
        }
        
        acitivityTips.snp.makeConstraints { make in
            make.top.equalTo(acitivityApplyInfo.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-32)
        }
        acitivityTips.layoutIfNeeded()
    
    }
}
